/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.utils;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;

public final class TooltipUtil {
    private TooltipUtil() {
    }

    public static void appendItemEffectTooltips(ItemStack itemStack, List<Component> tooltipLines) {
        record EffectRow(MobEffectInstance instance, float probability, boolean showChance) {
        }
        ArrayList<EffectRow> collectedEffects = new ArrayList<EffectRow>();
        for (Object effectInstance : PotionUtils.m_43547_((ItemStack)itemStack)) {
            collectedEffects.add(new EffectRow((MobEffectInstance)effectInstance, 1.0f, false));
        }
        FoodProperties foodProperties = itemStack.m_41720_().m_41473_();
        if (foodProperties != null) {
            for (Pair entry : foodProperties.m_38749_()) {
                float probability;
                if (entry == null) continue;
                MobEffectInstance effectInstance = (MobEffectInstance)entry.getFirst();
                float f = probability = entry.getSecond() == null ? 1.0f : ((Float)entry.getSecond()).floatValue();
                if (effectInstance == null) continue;
                collectedEffects.add(new EffectRow(effectInstance, probability, probability < 0.999f));
            }
        }
        if (itemStack.m_150930_(Items.f_42718_) && itemStack.m_41782_()) {
            ListTag effectsTag = itemStack.m_41783_().m_128437_("Effects", 10);
            for (int i = 0; i < effectsTag.size(); ++i) {
                MobEffect mobEffect;
                CompoundTag compoundTag = effectsTag.m_128728_(i);
                if (!compoundTag.m_128425_("EffectId", 1) || (mobEffect = MobEffect.m_19453_((int)(compoundTag.m_128445_("EffectId") & 0xFF))) == null) continue;
                int duration = compoundTag.m_128425_("EffectDuration", 3) ? compoundTag.m_128451_("EffectDuration") : 160;
                collectedEffects.add(new EffectRow(new MobEffectInstance(mobEffect, duration), 1.0f, false));
            }
        }
        if (collectedEffects.isEmpty()) {
            return;
        }
        collectedEffects.sort(Comparator.comparingInt(row -> row.instance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL ? 1 : 0).thenComparingInt(row -> -row.instance.m_19564_()).thenComparing(row -> row.instance.m_19544_().m_19482_().getString()));
        for (EffectRow effectRow : collectedEffects) {
            tooltipLines.add(TooltipUtil.formatEffectLine(effectRow.instance));
        }
        tooltipLines.add((Component)Component.m_237119_());
    }

    public static Component styledKeyFromMapping(KeyMapping keyMapping, boolean isActive) {
        return keyMapping.m_90863_().m_6881_().m_130940_(isActive ? ChatFormatting.WHITE : ChatFormatting.GRAY);
    }

    public static Component styledKey(Component keyComponent, boolean isActive) {
        return keyComponent.m_6881_().m_130940_(isActive ? ChatFormatting.WHITE : ChatFormatting.GRAY);
    }

    private static Component formatEffectLine(MobEffectInstance mobEffectInstance) {
        MobEffect mobEffect = mobEffectInstance.m_19544_();
        Component effectDisplayName = mobEffect.m_19482_();
        int amplifier = mobEffectInstance.m_19564_();
        int totalTicks = mobEffectInstance.m_19557_();
        MutableComponent effectLine = Component.m_237113_((String)"").m_7220_(effectDisplayName);
        if (amplifier > 0) {
            effectLine.m_7220_((Component)Component.m_237113_((String)(" " + TooltipUtil.toRomanNumeral(amplifier + 1))));
        }
        if (totalTicks > 0) {
            effectLine.m_7220_((Component)Component.m_237113_((String)(" (" + TooltipUtil.formatDurationTicksToMMSS(totalTicks) + ")")));
        }
        ChatFormatting lineColor = switch (mobEffect.m_19483_()) {
            case MobEffectCategory.BENEFICIAL -> ChatFormatting.BLUE;
            case MobEffectCategory.HARMFUL -> ChatFormatting.RED;
            default -> ChatFormatting.GRAY;
        };
        return effectLine.m_130940_(lineColor);
    }

    private static String formatDurationTicksToMMSS(int durationTicks) {
        int totalSeconds = Math.max(0, durationTicks / 20);
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    private static String toRomanNumeral(int value) {
        int[] arabic = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] roman = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        int remaining = Math.max(1, Math.min(3999, value));
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < arabic.length; ++i) {
            while (remaining >= arabic[i]) {
                remaining -= arabic[i];
                result.append(roman[i]);
            }
        }
        return result.toString();
    }
}

