/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.calamity.events;

import com.yourname.calamity.config.CalamityConfig;
import com.yourname.calamity.events.CalamityEvents;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CalamityEventHandler {
    private final Map<ServerPlayer, Integer> playerTimers = new HashMap<ServerPlayer, Integer>();
    private final Map<ServerPlayer, ServerBossEvent> playerBossBars = new HashMap<ServerPlayer, ServerBossEvent>();
    private final Map<ServerPlayer, CalamityEvents> currentEvents = new HashMap<ServerPlayer, CalamityEvents>();
    private final Random random = new Random();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side.isServer() && event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!this.playerTimers.containsKey(serverPlayer)) {
                this.playerTimers.put(serverPlayer, CalamityConfig.getEventIntervalTicks());
                this.createBossBar(serverPlayer);
            }
            int currentTicks = this.playerTimers.get(serverPlayer);
            if (--currentTicks <= 0) {
                CalamityEvents randomEvent = CalamityEvents.getRandomEvent(this.random);
                this.currentEvents.put(serverPlayer, randomEvent);
                randomEvent.execute(serverPlayer);
                currentTicks = CalamityConfig.getEventIntervalTicks();
            }
            this.playerTimers.put(serverPlayer, currentTicks);
            this.updateBossBar(serverPlayer, currentTicks);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerBossEvent bossBar = this.playerBossBars.remove(serverPlayer);
            if (bossBar != null) {
                bossBar.m_7706_();
            }
            this.playerTimers.remove(serverPlayer);
            this.currentEvents.remove(serverPlayer);
        }
    }

    private void createBossBar(ServerPlayer player) {
        ServerBossEvent bossBar = new ServerBossEvent((Component)Component.m_237113_((String)"Next Event in: 30s"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
        bossBar.m_6543_(player);
        this.playerBossBars.put(player, bossBar);
    }

    private void updateBossBar(ServerPlayer player, int ticksRemaining) {
        ServerBossEvent bossBar = this.playerBossBars.get(player);
        if (bossBar != null) {
            int secondsRemaining = ticksRemaining / 20;
            int maxTicks = CalamityConfig.getEventIntervalTicks();
            float progress = (float)ticksRemaining / (float)maxTicks;
            CalamityEvents currentEvent = this.currentEvents.get(player);
            String eventName = currentEvent != null ? currentEvent.getDisplayName() : "Waiting";
            bossBar.m_6456_((Component)Component.m_237113_((String)(eventName + " | Next in: " + secondsRemaining + "s")));
            bossBar.m_142711_(Math.max(0.0f, Math.min(1.0f, progress)));
        }
    }
}

