/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.calamity.events;

import com.yourname.calamity.config.CalamityConfig;
import com.yourname.calamity.util.EffectUtil;
import com.yourname.calamity.util.SafeTeleportUtil;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CalamityEvents {
    LIGHTS_OUT("Lights Out"){

        @Override
        public void execute(ServerPlayer player) {
            EffectUtil.applyTimedEffect(player, MobEffects.f_216964_);
        }
    }
    ,
    A_QUIET_PLACE("A Quiet Place"){

        @Override
        public void execute(ServerPlayer player) {
            SafeTeleportUtil.spawnEntitySafely(player, EntityType.f_217015_);
        }
    }
    ,
    BYE_BYE("Bye-Bye"){

        @Override
        public void execute(ServerPlayer player) {
            player.m_150109_().m_6211_();
        }
    }
    ,
    MIDAS_TOUCH("Midas Touch"){

        @Override
        public void execute(ServerPlayer player) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                if (!player.m_150109_().m_8020_(i).m_41619_()) continue;
                player.m_150109_().m_6836_(i, new ItemStack((ItemLike)Items.f_42417_, 64));
            }
        }
    }
    ,
    THE_FLASH("The Flash"){

        @Override
        public void execute(ServerPlayer player) {
            EffectUtil.applyTimedEffect(player, MobEffects.f_19596_, 255);
        }
    }
    ,
    FALLEN_ANGEL("Fallen Angel"){

        @Override
        public void execute(ServerPlayer player) {
            SafeTeleportUtil.teleportToY(player, 300);
        }
    }
    ,
    MR_POPULAR("Mr. Popular"){

        @Override
        public void execute(ServerPlayer player) {
            int duration = CalamityConfig.getEventIntervalTicks();
            for (int i = 0; i < duration / 20; ++i) {
                player.m_20194_().execute(() -> SafeTeleportUtil.spawnEntitySafely(player, EntityType.f_20492_));
            }
        }
    }
    ,
    DIVINELY_BLESSED("Divinely Blessed"){

        @Override
        public void execute(ServerPlayer player) {
            EffectUtil.applyAllBeneficialEffects(player);
        }
    }
    ,
    DIVINELY_CURSED("Divinely Cursed"){

        @Override
        public void execute(ServerPlayer player) {
            EffectUtil.applyAllNegativeEffects(player);
        }
    }
    ,
    THE_WALKING_DEAD("The Walking Dead"){

        @Override
        public void execute(ServerPlayer player) {
            for (int i = 0; i < 10; ++i) {
                SafeTeleportUtil.spawnEntitySafely(player, EntityType.f_20501_);
            }
        }
    }
    ,
    THANKS_FOR_NOTHING("Thanks for Nothing"){

        @Override
        public void execute(ServerPlayer player) {
            SafeTeleportUtil.teleportToNearestVillage(player);
            player.m_20194_().execute(() -> {
                Level patt3720$temp = player.m_9236_();
                if (patt3720$temp instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt3720$temp;
                    serverLevel.m_8905_().m_37963_(player);
                }
            });
        }
    }
    ,
    A_SPOT_OF_SPEEDRUNNING("A Spot of Speedrunning"){

        @Override
        public void execute(ServerPlayer player) {
            SafeTeleportUtil.teleportToEnd(player);
        }
    }
    ,
    WELCOME_TO_HELL("Welcome to Hell"){

        @Override
        public void execute(ServerPlayer player) {
            SafeTeleportUtil.teleportToNether(player);
        }
    }
    ,
    LIONS_DEN("Lion's Den"){

        @Override
        public void execute(ServerPlayer player) {
            SafeTeleportUtil.teleportToNearestAncientCity(player);
        }
    }
    ,
    CPVP("CPVP"){

        @Override
        public void execute(ServerPlayer player) {
            player.m_150109_().m_6211_();
            player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42388_));
            player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42740_));
            player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42411_));
            player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42412_, 16));
            player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42747_, 3));
            player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42436_, 3));
            player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_41829_, 2));
            player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42729_, 2));
            ItemStack helmet = new ItemStack((ItemLike)Items.f_42468_);
            helmet.m_41663_(Enchantments.f_44965_, 3);
            ItemStack chestplate = new ItemStack((ItemLike)Items.f_42469_);
            chestplate.m_41663_(Enchantments.f_44965_, 3);
            ItemStack leggings = new ItemStack((ItemLike)Items.f_42470_);
            leggings.m_41663_(Enchantments.f_44965_, 3);
            ItemStack boots = new ItemStack((ItemLike)Items.f_42471_);
            boots.m_41663_(Enchantments.f_44965_, 3);
            player.m_8061_(EquipmentSlot.HEAD, helmet);
            player.m_8061_(EquipmentSlot.CHEST, chestplate);
            player.m_8061_(EquipmentSlot.LEGS, leggings);
            player.m_8061_(EquipmentSlot.FEET, boots);
        }
    }
    ,
    STAY_HYDRATED("Stay Hydrated"){

        @Override
        public void execute(ServerPlayer player) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                if (!player.m_150109_().m_8020_(i).m_41619_()) continue;
                player.m_150109_().m_6836_(i, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_));
            }
        }
    }
    ,
    GLOW_IN_THE_DARK("Glow In The Dark"){

        @Override
        public void execute(ServerPlayer player) {
            EffectUtil.applyTimedEffect(player, MobEffects.f_19619_);
        }
    }
    ,
    ITS_YOUR_LUCKY_DAY("It's Your Lucky Day"){

        @Override
        public void execute(ServerPlayer player) {
            EffectUtil.applyTimedEffect(player, MobEffects.f_19621_, 255);
        }
    }
    ,
    ONE_IN_A_MILLION("One in a Million"){

        @Override
        public void execute(ServerPlayer player) {
            for (int i = 0; i < 15; ++i) {
                Sheep sheep = (Sheep)EntityType.f_20520_.m_20615_(player.m_9236_());
                if (sheep == null) continue;
                sheep.m_29855_(DyeColor.PINK);
                Vec3 spawnPos = SafeTeleportUtil.getSafeSpawnPosition(player);
                sheep.m_6027_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
                player.m_9236_().m_7967_((Entity)sheep);
            }
        }
    }
    ,
    ANTI_MIDAS_TOUCH("Anti-Midas Touch"){

        @Override
        public void execute(ServerPlayer player) {
            for (int i = 0; i < 10; ++i) {
                SafeTeleportUtil.spawnEntitySafely(player, EntityType.f_20523_);
            }
        }
    }
    ,
    VANISH("Vanish"){

        @Override
        public void execute(ServerPlayer player) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (stack.m_41619_()) continue;
                stack.m_41663_(Enchantments.f_44963_, 1);
            }
        }
    }
    ,
    WHAT_IS_THAT("What is That"){

        @Override
        public void execute(ServerPlayer player) {
            player.m_213846_((Component)Component.m_237113_((String)"Watch your step!"));
        }
    }
    ,
    BE_SAFE_OUT_THERE("Be Safe Out There"){

        @Override
        public void execute(ServerPlayer player) {
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8615_(18000L);
            }
            ItemStack pumpkin = new ItemStack((ItemLike)Items.f_42047_);
            pumpkin.m_41663_(Enchantments.f_44975_, 1);
            pumpkin.m_41663_(Enchantments.f_44986_, 5);
            player.m_8061_(EquipmentSlot.HEAD, pumpkin);
        }
    }
    ,
    POKEMON_MINECRAFT_VERSION("Pokemon: Minecraft Version"){

        @Override
        public void execute(ServerPlayer player) {
            EntityType[] spawnEggs = new EntityType[]{EntityType.f_20510_, EntityType.f_20557_, EntityType.f_20555_, EntityType.f_20520_, EntityType.f_20499_, EntityType.f_20553_, EntityType.f_20457_, EntityType.f_20550_};
            Random random = new Random();
            EntityType randomEntity = spawnEggs[random.nextInt(spawnEggs.length)];
            ItemStack spawnEgg = new ItemStack((ItemLike)Items.f_42645_);
            spawnEgg.m_41714_((Component)Component.m_237113_((String)"PokeBall"));
            player.m_150109_().m_36054_(spawnEgg);
        }
    }
    ,
    CLINGING_TO_LIFE("Clinging to Life"){

        @Override
        public void execute(ServerPlayer player) {
            player.m_21153_(1.0f);
        }
    }
    ,
    STARVATION("Starvation"){

        @Override
        public void execute(ServerPlayer player) {
            player.m_36324_().m_38705_(1);
        }
    }
    ,
    WRATH_OF_ZEUS("Wrath of Zeus"){

        @Override
        public void execute(ServerPlayer player) {
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos pos = player.m_20183_();
                EntityType.f_20465_.m_262455_(serverLevel, new CompoundTag(), null, pos, MobSpawnType.TRIGGERED, true, true);
            }
        }
    }
    ,
    FLY_OR_DIE("Fly or Die"){

        @Override
        public void execute(ServerPlayer player) {
            SafeTeleportUtil.teleportToY(player, 300);
            ItemStack elytra = new ItemStack((ItemLike)Items.f_42741_);
            elytra.m_41663_(Enchantments.f_44975_, 1);
            elytra.m_41663_(Enchantments.f_44986_, 5);
            player.m_8061_(EquipmentSlot.CHEST, elytra);
        }
    }
    ,
    FORCED_PEARL("Forced Pearl"){

        @Override
        public void execute(ServerPlayer player) {
            SafeTeleportUtil.randomTeleport(player, 1000);
        }
    }
    ,
    THE_WIZARD_OF_OZ("The Wizard of Oz"){

        @Override
        public void execute(ServerPlayer player) {
            SafeTeleportUtil.spawnEntitySafely(player, EntityType.f_20495_);
            ItemStack boots = new ItemStack((ItemLike)Items.f_42463_);
            CompoundTag display = boots.m_41698_("display");
            display.m_128405_("color", 0xFF0000);
            boots.m_41714_((Component)Component.m_237113_((String)"Dorothy's Boots"));
            boots.m_41663_(Enchantments.f_44965_, 3);
            boots.m_41663_(Enchantments.f_44986_, 2);
            boots.m_41663_(Enchantments.f_44974_, 1);
            boots.m_41663_(Enchantments.f_44975_, 1);
            player.m_8061_(EquipmentSlot.FEET, boots);
        }
    }
    ,
    MAGIC_IS_BANNED("Magic is Banned"){

        @Override
        public void execute(ServerPlayer player) {
            CompoundTag tag;
            player.m_21219_();
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (stack.m_41619_() || !stack.m_41793_() || (tag = stack.m_41783_()) == null) continue;
                tag.m_128473_("Enchantments");
                tag.m_128473_("StoredEnchantments");
            }
            for (ItemStack armorPiece : player.m_6168_()) {
                if (armorPiece.m_41619_() || !armorPiece.m_41793_() || (tag = armorPiece.m_41783_()) == null) continue;
                tag.m_128473_("Enchantments");
                tag.m_128473_("StoredEnchantments");
            }
        }
    }
    ,
    HOCUS_POCUS("Hocus Pocus"){

        @Override
        public void execute(ServerPlayer player) {
            Random random = new Random();
            for (int attempt = 0; attempt < 10; ++attempt) {
                int slot = random.nextInt(player.m_150109_().m_6643_());
                ItemStack stack = player.m_150109_().m_8020_(slot);
                if (stack.m_41619_()) continue;
                Enchantment[] enchantments = new Enchantment[]{Enchantments.f_44977_, Enchantments.f_44981_, Enchantments.f_44980_, Enchantments.f_44965_, Enchantments.f_44986_, Enchantments.f_44962_};
                Enchantment randomEnch = enchantments[random.nextInt(enchantments.length)];
                int level = random.nextInt(5) + 1;
                stack.m_41663_(randomEnch, level);
                break;
            }
        }
    };

    private final String displayName;

    private CalamityEvents(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public abstract void execute(ServerPlayer var1);

    public static CalamityEvents getRandomEvent(Random random) {
        CalamityEvents[] events = CalamityEvents.values();
        return events[random.nextInt(events.length)];
    }
}

