/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.calamity.util;

import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class SafeTeleportUtil {
    private static final Random RANDOM = new Random();

    public static void teleportToY(ServerPlayer player, int targetY) {
        BlockPos currentPos = player.m_20183_();
        BlockPos targetPos = new BlockPos(currentPos.m_123341_(), targetY, currentPos.m_123343_());
        BlockPos safePos = SafeTeleportUtil.findSafePosition(player.m_284548_(), targetPos);
        player.m_6021_((double)safePos.m_123341_() + 0.5, (double)safePos.m_123342_(), (double)safePos.m_123343_() + 0.5);
    }

    public static void teleportToNether(ServerPlayer player) {
        ServerLevel nether = player.f_8924_.m_129880_(Level.f_46429_);
        if (nether != null) {
            BlockPos pos = player.m_20183_();
            BlockPos netherPos = new BlockPos(pos.m_123341_() / 8, 64, pos.m_123343_() / 8);
            final BlockPos safePos = SafeTeleportUtil.findSafePosition(nether, netherPos);
            player.changeDimension(nether, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                    entity = repositionEntity.apply(false);
                    entity.m_6021_((double)safePos.m_123341_() + 0.5, (double)safePos.m_123342_(), (double)safePos.m_123343_() + 0.5);
                    return entity;
                }
            });
        }
    }

    public static void teleportToEnd(ServerPlayer player) {
        ServerLevel end = player.f_8924_.m_129880_(Level.f_46430_);
        if (end != null) {
            BlockPos spawnPos = ServerLevel.f_8562_;
            final BlockPos safePos = SafeTeleportUtil.findSafePosition(end, spawnPos);
            player.changeDimension(end, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                    entity = repositionEntity.apply(false);
                    entity.m_6021_((double)safePos.m_123341_() + 0.5, (double)safePos.m_123342_(), (double)safePos.m_123343_() + 0.5);
                    return entity;
                }
            });
        }
    }

    public static void teleportToNearestVillage(ServerPlayer player) {
        SafeTeleportUtil.randomTeleport(player, 500);
    }

    public static void teleportToNearestAncientCity(ServerPlayer player) {
        BlockPos currentPos = player.m_20183_();
        BlockPos targetPos = new BlockPos(currentPos.m_123341_(), -52, currentPos.m_123343_());
        BlockPos safePos = SafeTeleportUtil.findSafePosition(player.m_284548_(), targetPos);
        player.m_6021_((double)safePos.m_123341_() + 0.5, (double)safePos.m_123342_(), (double)safePos.m_123343_() + 0.5);
    }

    public static void randomTeleport(ServerPlayer player, int radius) {
        BlockPos currentPos = player.m_20183_();
        int x = currentPos.m_123341_() + RANDOM.nextInt(radius * 2) - radius;
        int z = currentPos.m_123343_() + RANDOM.nextInt(radius * 2) - radius;
        int y = player.m_284548_().m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        BlockPos targetPos = new BlockPos(x, y, z);
        BlockPos safePos = SafeTeleportUtil.findSafePosition(player.m_284548_(), targetPos);
        player.m_6021_((double)safePos.m_123341_() + 0.5, (double)safePos.m_123342_(), (double)safePos.m_123343_() + 0.5);
    }

    public static BlockPos findSafePosition(ServerLevel level, BlockPos target) {
        for (int yOffset = 0; yOffset <= 10; ++yOffset) {
            for (int xzOffset = 0; xzOffset <= 3; ++xzOffset) {
                BlockPos checkPos = target.m_7918_(xzOffset, yOffset, xzOffset);
                if (SafeTeleportUtil.isSafePosition(level, checkPos)) {
                    return checkPos;
                }
                checkPos = target.m_7918_(-xzOffset, yOffset, xzOffset);
                if (SafeTeleportUtil.isSafePosition(level, checkPos)) {
                    return checkPos;
                }
                checkPos = target.m_7918_(xzOffset, yOffset, -xzOffset);
                if (SafeTeleportUtil.isSafePosition(level, checkPos)) {
                    return checkPos;
                }
                checkPos = target.m_7918_(-xzOffset, yOffset, -xzOffset);
                if (!SafeTeleportUtil.isSafePosition(level, checkPos)) continue;
                return checkPos;
            }
        }
        return target;
    }

    public static boolean isSafePosition(ServerLevel level, BlockPos pos) {
        BlockState feetBlock = level.m_8055_(pos);
        BlockState headBlock = level.m_8055_(pos.m_7494_());
        BlockState groundBlock = level.m_8055_(pos.m_7495_());
        return !feetBlock.m_60828_((BlockGetter)level, pos) && !headBlock.m_60828_((BlockGetter)level, pos) && groundBlock.m_280296_() && !groundBlock.m_278721_();
    }

    public static void spawnEntitySafely(ServerPlayer player, EntityType<?> entityType) {
        Vec3 spawnPos = SafeTeleportUtil.getSafeSpawnPosition(player);
        entityType.m_262455_(player.m_284548_(), new CompoundTag(), null, BlockPos.m_274446_((Position)spawnPos), MobSpawnType.TRIGGERED, true, true);
    }

    public static Vec3 getSafeSpawnPosition(ServerPlayer player) {
        BlockPos playerPos = player.m_20183_();
        BlockPos safePos = SafeTeleportUtil.findSafePosition(player.m_284548_(), playerPos.m_7918_(RANDOM.nextInt(6) - 3, 0, RANDOM.nextInt(6) - 3));
        return new Vec3((double)safePos.m_123341_() + 0.5, (double)safePos.m_123342_(), (double)safePos.m_123343_() + 0.5);
    }
}

