/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.entity.render;

import com.jdolphin.ricksportalgun.client.entity.model.PortalEntityModel;
import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;

public class PortalEntityRenderer
extends EntityRenderer<PortalEntity> {
    public static final ResourceLocation PORTAL_TEXTURE = PGHelper.id("textures/entity/portal.png");
    public PortalEntityModel model;
    private static int textureFrame = 0;
    private static final int frames = 8;
    private final List<String> names = List.of(new String[]{"_jeb", "rainbow", "rgb", "colourful", "colorful"});
    private static int tickTimer = 0;

    public PortalEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new PortalEntityModel(pContext.m_174023_(PortalEntityModel.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(PortalEntity entity) {
        return PORTAL_TEXTURE;
    }

    public ResourceLocation getPortalTexture(int i) {
        return PGHelper.id("textures/entity/portal_" + i + ".png");
    }

    protected void openAnimation(PortalEntity state, PoseStack stack) {
        float f;
        if (!state.exists() && (double)state.f_19797_ < (double)state.getLifetime() * 0.1) {
            f = Mth.m_14179_((float)((float)state.f_19797_ / 20.0f), (float)0.0f, (float)1.0f);
            f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            stack.m_85841_(f, f, f);
        }
        if ((double)state.f_19797_ > (double)state.getLifetime() * 0.9) {
            f = Mth.m_14179_((float)((float)state.f_19797_ / 20.0f), (float)1.0f, (float)0.0f);
            f = Mth.m_14036_((float)f, (float)1.0f, (float)0.0f);
            f *= f;
            f *= f;
            stack.m_85841_(f, f, f);
        }
    }

    public void render(PortalEntity entity, float yaw, float partialTick, PoseStack stack, MultiBufferSource source, int packedLight) {
        stack.m_85836_();
        this.openAnimation(entity, stack);
        Direction direction = entity.getPortalDirection();
        Direction facing = entity.getPortalFacing();
        stack.m_252880_(0.0f, -1.0f, 0.0f);
        if (direction != null) {
            float height;
            Direction.Axis axis = facing.m_122434_();
            float zRot = 0.0f;
            float yRot = 0.0f;
            float xRot = 0.0f;
            float f = height = entity.getSize() > 2.0f ? entity.getSize() / 2.0f : 1.0f;
            if (direction.m_122434_().m_122478_()) {
                if (axis.equals((Object)Direction.Axis.Z)) {
                    stack.m_85841_(entity.getSize(), 1.0f, height);
                    zRot = 180.0f;
                    yRot = 180.0f;
                    xRot = 90.0f;
                    stack.m_85837_(0.0, 1.1, -1.0);
                }
                if (axis.equals((Object)Direction.Axis.X)) {
                    stack.m_85841_(height, 1.0f, entity.getSize());
                    xRot = 0.0f;
                    yRot = 270.0f;
                    zRot = 90.0f;
                    stack.m_85837_(-1.0, 1.1, 0.0);
                }
            } else {
                stack.m_85841_(entity.getSize(), height, entity.getSize());
            }
            stack.m_252781_(Axis.f_252495_.m_252977_(xRot));
            stack.m_252781_(Axis.f_252393_.m_252977_(zRot));
            stack.m_252781_(Axis.f_252392_.m_252977_(direction.m_122434_().m_122478_() ? yRot : entity.m_146908_()));
        }
        VertexConsumer consumer = source.m_6299_(RenderType.m_110473_((ResourceLocation)this.getPortalTexture(textureFrame)));
        int color = entity.getColor();
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        if (this.names.contains(entity.m_7755_().getString().toLowerCase())) {
            int i = entity.f_19797_ / 25 + entity.m_19879_();
            int j = DyeColor.values().length;
            int k = i % j;
            int l = (i + 1) % j;
            float f3 = ((float)(entity.f_19797_ % 25) + partialTick) / 25.0f;
            float[] afloat1 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)k));
            float[] afloat2 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)l));
            r = afloat1[0] * (1.0f - f3) + afloat2[0] * f3;
            g = afloat1[1] * (1.0f - f3) + afloat2[1] * f3;
            b = afloat1[2] * (1.0f - f3) + afloat2[2] * f3;
        }
        this.model.m_7695_(stack, consumer, 0xF000F0, OverlayTexture.f_118083_, r, g, b, 1.0f);
        stack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTick, stack, source, 0xF000F0);
    }

    public static void tickTexture() {
        if (++tickTimer >= 4) {
            tickTimer = 0;
            textureFrame = (textureFrame + 1) % 8;
        }
    }
}

