/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.widget;

import com.jdolphin.ricksportalgun.client.screen.portalgun.WaypointInfoScreen;
import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGTextButton;
import com.jdolphin.ricksportalgun.client.screen.widget.ScrollableList;
import com.jdolphin.ricksportalgun.common.item.IWaypointStorage;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBSetDestinationPacket;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;

public class WaypointListWidget
extends ScrollableList<WaypointEntry> {
    public static ResourceLocation WAYPOINT_INFO_TEXTURES = PGHelper.id("textures/gui/sprites/icon/waypoint_info.png");
    public boolean showInfoButton;
    public int rowWidth = 188;
    private final int buttonWidth;
    private final int buttonHeight;
    private boolean renderButtonBg = true;
    protected Button.OnPress onPress;
    private PortalGunStyle style = PortalGunStyle.DEFAULT;

    public WaypointListWidget(int width, int height, int x, int y, int itemHeight, ItemStack stack, boolean showInfo, int buttonWidth, int buttonHeight) {
        super(Minecraft.m_91087_(), width, height, x, y, itemHeight);
        this.showInfoButton = showInfo;
        this.buttonWidth = buttonWidth;
        this.buttonHeight = buttonHeight;
        this.refreshEntries(stack);
        this.setRenderScrollbar(false);
    }

    public void setStyle(PortalGunStyle style) {
        this.style = style;
    }

    public void refreshEntries(ItemStack stack) {
        this.m_6702_().clear();
        List<String> waypoints = IWaypointStorage.getWaypoints(stack);
        for (String waypoint : waypoints) {
            if (waypoint != null) {
                this.addEntry(new WaypointEntry(Waypoint.getWaypoint(waypoint), this, this.showInfoButton, this.renderButtonBg, this.style.highlightColor()));
                continue;
            }
            LogManager.getLogger().warn("Failed to get Waypoint");
        }
    }

    @Override
    public int getRowWidth() {
        return this.rowWidth;
    }

    public void setOnPress(Button.OnPress onPress) {
        this.onPress = onPress;
    }

    public void setRenderButtonBackground(boolean renderButtonBg) {
        this.renderButtonBg = renderButtonBg;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public static class WaypointEntry
    extends ScrollableList.Entry<WaypointEntry> {
        private final Button button;
        private final PGImageButton infoButton;
        protected WaypointListWidget list;
        private final boolean showInfo;
        private final int color;
        private final boolean renderBG;
        public final Waypoint waypoint;

        WaypointEntry(Waypoint waypoint, WaypointListWidget list, boolean showInfoButton, boolean renderButtonBG, int borderColor) {
            this.waypoint = waypoint;
            this.list = list;
            this.showInfo = showInfoButton;
            this.color = borderColor;
            this.renderBG = renderButtonBG;
            Button.OnPress press = this.list.onPress;
            if (this.list.onPress == null) {
                press = pButton -> {
                    SBSetDestinationPacket packet = new SBSetDestinationPacket(waypoint.getBlockPos(), waypoint.getDimension());
                    PGHelper.sendPacketToServer(packet);
                    Minecraft.m_91087_().m_91152_(null);
                };
            }
            this.button = renderButtonBG ? Button.m_253074_((Component)Component.m_237113_((String)waypoint.getName()), (Button.OnPress)press).m_252794_(16, 0).m_253046_(list.buttonWidth, list.buttonHeight).m_253136_() : new PGTextButton(16, 0, list.buttonWidth, list.buttonHeight, (Component)Component.m_237113_((String)waypoint.getName()), press, Minecraft.m_91087_().f_91062_);
            this.infoButton = new PGImageButton(0, 0, 20, 20, (Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.info"), button -> Minecraft.m_91087_().m_91152_((Screen)new WaypointInfoScreen(waypoint)), 20, 20, WAYPOINT_INFO_TEXTURES);
            this.infoButton.setRenderBackground(renderButtonBG);
            this.infoButton.setColor(this.list.style.textColor());
            this.infoButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.info")));
            Button button2 = this.button;
            if (button2 instanceof PGTextButton) {
                PGTextButton textButton = (PGTextButton)button2;
                textButton.setTextColour(this.list.style.textColor());
            }
        }

        @Override
        public void render(GuiGraphics graphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            WaypointListWidget wpList = this.list;
            if (pTop > wpList.headerHeight) {
                this.button.m_252865_(pLeft + (this.showInfo ? 18 : 56));
                this.button.m_253211_(pTop);
                this.button.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
                if (!this.renderBG) {
                    GuiHelper.renderOutline(graphics, (AbstractWidget)this.button, this.color);
                }
                if (this.showInfo) {
                    this.infoButton.m_252865_(pLeft + this.button.m_5711_() + 20);
                    this.infoButton.m_253211_(pTop);
                    if (!this.renderBG) {
                        GuiHelper.renderOutline(graphics, (AbstractWidget)this.infoButton, this.color);
                    }
                    this.infoButton.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
                }
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.button, this.infoButton);
        }

        public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
            if (this.button.m_6375_(pMouseX, pMouseY, pButton)) {
                return true;
            }
            return this.infoButton.m_6375_(pMouseX, pMouseY, pButton);
        }

        public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
            return this.button.m_6348_(pMouseX, pMouseY, pButton) || this.infoButton.m_6348_(pMouseX, pMouseY, pButton);
        }
    }
}

