/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.entity;

import com.jdolphin.ricksportalgun.common.init.PGDamageTypes;
import com.jdolphin.ricksportalgun.common.init.PGEntities;
import com.jdolphin.ricksportalgun.common.init.PGSounds;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGConfigHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class PortalEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_COLOR_ID = SynchedEntityData.m_135353_(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Direction> DATA_DIR = SynchedEntityData.m_135353_(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Direction> DATA_FACING = SynchedEntityData.m_135353_(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Float> DATA_SIZE = SynchedEntityData.m_135353_(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.m_135353_(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final String TAG_DIMENSION = "PortalDimension";
    public static final String TAG_BPOS = "PortalPos";
    public static final String TAG_OPEN = "Open";
    public static final String TAG_NEW = "isSpawned";
    public static final String TAG_COOLDOWN = "Cooldown";
    public static final String TAG_DIR = "Direction";
    public static final String TAG_FACING = "Facing";
    public static final String TAG_SIZE = "Size";
    public static final String TAG_ACIDIC = "Bootleg";
    public static final String TAG_COLOR = "Color";
    private BlockPos targetPos;
    private boolean bootleg;
    private boolean exists;
    private Vec3 pos;
    private Vec3 targetVec;
    private String targetDim;
    private ServerLevel destinationLevel;
    private int delay = 0;

    public boolean exists() {
        return this.exists;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public PortalEntity(EntityType<PortalEntity> type, Level level) {
        super(type, level);
    }

    public PortalEntity(Level pLevel, Vec3 pos, Direction direction, Direction facing, float size) {
        super(PGEntities.PORTAL, pLevel);
        this.m_146884_(pos);
        this.setPortalDirection(direction);
        this.setPortalFacing(facing);
        this.setSize(size);
        this.pos = pos;
    }

    public void setLifetime(int lifetime) {
        this.f_19804_.m_135381_(LIFETIME, (Object)lifetime);
    }

    public int getLifetime() {
        return (Integer)this.f_19804_.m_135370_(LIFETIME);
    }

    public void setColor(int color) {
        this.f_19804_.m_135381_(DATA_COLOR_ID, (Object)color);
    }

    public void setPortalDirection(Direction direction) {
        this.f_19804_.m_135381_(DATA_DIR, (Object)direction);
    }

    public void setPortalFacing(Direction direction) {
        this.f_19804_.m_135381_(DATA_FACING, (Object)direction);
    }

    public Direction getPortalFacing() {
        return (Direction)this.f_19804_.m_135370_(DATA_FACING);
    }

    public Direction getPortalDirection() {
        return (Direction)this.f_19804_.m_135370_(DATA_DIR);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(DATA_COLOR_ID);
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(DATA_SIZE)).floatValue();
    }

    public void setSize(float size) {
        this.f_19804_.m_135381_(DATA_SIZE, (Object)Float.valueOf(size));
    }

    public boolean isBootleg() {
        return this.bootleg;
    }

    public void setBootleg(boolean bootleg) {
        this.bootleg = bootleg;
    }

    public static boolean colliding(Entity entity1, Entity entity2) {
        return entity1.m_20191_().m_82381_(entity2.m_20191_());
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6469_(DamageSource damageSource, float v) {
        return false;
    }

    public boolean isFlat() {
        Direction direction = (Direction)this.f_19804_.m_135370_(DATA_DIR);
        return direction.equals((Object)Direction.UP) || direction.equals((Object)Direction.DOWN);
    }

    public void setHopLocation(ResourceLocation dimension, BlockPos pos) {
        this.targetDim = dimension.toString();
        this.targetPos = pos;
    }

    public BlockPos getHopLoc() {
        return this.targetPos == null ? BlockPos.f_121853_ : this.targetPos;
    }

    public String getHopDim() {
        return this.targetDim == null ? "minecraft:overworld" : this.targetDim;
    }

    protected void m_7378_(CompoundTag tag) {
        this.bootleg = tag.m_128471_(TAG_ACIDIC);
        this.targetDim = tag.m_128461_(TAG_DIMENSION);
        CompoundTag bpTag = tag.m_128469_(TAG_BPOS);
        this.targetPos = NbtUtils.m_129239_((CompoundTag)bpTag);
        this.setColor(tag.m_128451_(TAG_COLOR));
        this.setLifetime(tag.m_128451_(TAG_OPEN));
        this.delay = tag.m_128451_(TAG_COOLDOWN);
        this.exists = tag.m_128471_(TAG_NEW);
        this.setPortalDirection(Direction.m_122402_((String)tag.m_128461_(TAG_DIR)));
        this.setPortalFacing(Direction.m_122402_((String)tag.m_128461_(TAG_FACING)));
        this.setSize(tag.m_128457_(TAG_SIZE));
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128379_(TAG_ACIDIC, this.bootleg);
        tag.m_128379_(TAG_NEW, this.exists);
        tag.m_128359_(TAG_DIMENSION, this.getHopDim());
        tag.m_128365_(TAG_BPOS, (Tag)NbtUtils.m_129224_((BlockPos)this.getHopLoc()));
        tag.m_128405_(TAG_COLOR, this.getColor());
        tag.m_128405_(TAG_OPEN, this.getLifetime());
        tag.m_128405_(TAG_COOLDOWN, this.delay);
        tag.m_128359_(TAG_DIR, this.getPortalDirection().m_122433_());
        tag.m_128359_(TAG_FACING, this.getPortalFacing().m_122433_());
        tag.m_128350_(TAG_SIZE, this.getSize());
    }

    public void m_6034_(double x, double y, double z) {
        this.pos = new Vec3(x, y, z);
        this.m_20343_(x, y, z);
        this.recalculateBoundingBox();
    }

    protected final void recalculateBoundingBox() {
        Direction direction = (Direction)this.f_19804_.m_135370_(DATA_DIR);
        Direction facing = (Direction)this.f_19804_.m_135370_(DATA_FACING);
        AABB aabb = this.calculateBoundingBox(this.pos, direction, facing);
        Vec3 vec3 = aabb.m_82399_();
        this.m_20343_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        this.m_20011_(aabb);
    }

    protected AABB calculateBoundingBox(Vec3 vec3, Direction dir, Direction facing) {
        double d2;
        Direction.Axis axis = dir.m_122434_();
        boolean flat = axis.equals((Object)Direction.Axis.Y);
        double height = this.getSize() > 2.0f ? (double)this.getSize() : 2.0;
        double d0 = axis.equals((Object)Direction.Axis.X) ? 0.1 : (double)this.getSize();
        double d1 = flat ? 0.1 : height;
        double d = d2 = axis.equals((Object)Direction.Axis.Z) ? 0.1 : (double)this.getSize();
        if (flat) {
            Direction.Axis axis2d = facing.m_122434_();
            d0 = axis2d.equals((Object)Direction.Axis.X) ? height : (double)this.getSize();
            d2 = axis2d.equals((Object)Direction.Axis.Z) ? height : (double)this.getSize();
        }
        return AABB.m_165882_((Vec3)vec3, (double)d0, (double)d1, (double)d2);
    }

    public static List<Entity> getEntitiesNearby(Entity entity, double range) {
        if (!entity.m_9236_().m_5776_()) {
            AABB boundingBox = entity.m_20191_().m_82400_(range);
            List entities = entity.m_9236_().m_45976_(Entity.class, boundingBox);
            entities.remove(entity);
            entities.removeIf(e -> {
                String entityAsString = PGHelper.getEntityAsString(e.m_6095_());
                return PGConfigHelper.getDisabledEntities().contains(entityAsString);
            });
            entities.removeIf(e -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    return player.m_20092_() || player.m_8958_();
                }
                return false;
            });
            return entities;
        }
        return null;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_COLOR_ID, (Object)Color.GREEN.getRGB());
        this.f_19804_.m_135372_(DATA_DIR, (Object)Direction.SOUTH);
        this.f_19804_.m_135372_(DATA_FACING, (Object)Direction.SOUTH);
        this.f_19804_.m_135372_(DATA_SIZE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(LIFETIME, (Object)PGHelper.seconds(10));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            List<Entity> entityList;
            boolean shouldHurt;
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            if (!this.exists) {
                LevelHelper.playSound(this.m_9236_(), this.m_20183_(), PGSounds.PORTAL_SHOOT, SoundSource.PLAYERS);
                this.exists = true;
            }
            if (this.getLifetime() > 0) {
                int l = this.getLifetime();
                this.setLifetime(l - 1);
            }
            if (this.delay > 0) {
                --this.delay;
            }
            if (!this.f_19803_ && this.getLifetime() == 0) {
                this.m_9236_().m_7726_().m_6692_(new ChunkPos(this.m_20183_()), false);
                this.m_6074_();
                return;
            }
            if (this.destinationLevel == null) {
                if (!this.isBootleg() && !LevelHelper.isBlenderDestination(this.getHopDim())) {
                    ResourceKey<Level> key = LevelHelper.getWorldKey(new ResourceLocation(this.getHopDim()));
                    this.destinationLevel = LevelHelper.getServerWorld(this.m_9236_(), key);
                } else {
                    this.destinationLevel = (ServerLevel)this.m_9236_();
                }
                if (this.targetPos == null) {
                    this.targetPos = this.getHopLoc();
                }
            }
            if (this.targetVec == null) {
                this.targetVec = Vec3.m_82503_((Vec2)new Vec2(45.0f, this.m_146908_() + 180.0f));
            }
            boolean bl = shouldHurt = this.isBootleg() || LevelHelper.isBlenderDestination(this.getHopDim());
            if ((shouldHurt || this.destinationLevel != null && this.targetPos != null) && (entityList = PortalEntity.getEntitiesNearby(this, 0.3)) != null && !entityList.isEmpty()) {
                for (Entity nearby : entityList) {
                    if (!PortalEntity.colliding(this, nearby) || nearby.m_20092_() || nearby.m_20159_() || this.delay != 0) continue;
                    if (!shouldHurt) {
                        HashSet<RelativeMovement> relativeSet = new HashSet<RelativeMovement>();
                        relativeSet.add(RelativeMovement.Y_ROT);
                        nearby.m_264318_(this.destinationLevel, (double)this.targetPos.m_123341_() + this.targetVec.f_82479_ * 2.0, (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_() + this.targetVec.f_82481_ * 2.0, relativeSet, nearby.m_146908_(), nearby.m_146909_());
                        nearby.m_183634_();
                        nearby.m_20091_();
                        continue;
                    }
                    if (nearby instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)nearby;
                        player.m_6469_(LevelHelper.isBlenderDestination(this.getHopDim()) ? PGDamageTypes.blender() : PGDamageTypes.bootleg(), Float.MAX_VALUE);
                        continue;
                    }
                    nearby.m_6074_();
                }
            }
        }
    }
}

