/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.command;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.command.ResetBookUnlocksCommand;
import com.klikli_dev.modonomicon.networking.SendUnlockCodeToClientMessage;
import com.klikli_dev.modonomicon.platform.Services;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class SaveUnlocksCommand
implements Command<CommandSourceStack> {
    private static final SaveUnlocksCommand CMD = new SaveUnlocksCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"save_progress").requires(cs -> cs.hasPermission(1))).then(Commands.argument((String)"book", (ArgumentType)ResourceLocationArgument.id()).suggests(ResetBookUnlocksCommand.SUGGEST_BOOK).executes((Command)CMD));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Book book = ResetBookUnlocksCommand.getBook(context, "book");
        String code = BookUnlockStateManager.get().getUnlockCodeFor((Player)((CommandSourceStack)context.getSource()).getPlayer(), book);
        Services.NETWORK.sendToSplit(((CommandSourceStack)context.getSource()).getPlayer(), new SendUnlockCodeToClientMessage(code));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"modonomicon.command.success.save_progress", (Object[])new Object[]{Component.translatable((String)book.getName())}), true);
        return 1;
    }
}

