/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.networking.Message;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class SendUnlockCodeToServerMessage
implements Message {
    public static final CustomPacketPayload.Type<SendUnlockCodeToServerMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"modonomicon", (String)"send_unlock_code_to_server"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SendUnlockCodeToServerMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, m -> m.unlockCode, SendUnlockCodeToServerMessage::new);
    public String unlockCode;

    public SendUnlockCodeToServerMessage(String unlockCode) {
        this.unlockCode = unlockCode;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        Book book = BookUnlockStateManager.get().applyUnlockCodeFor(player, this.unlockCode);
        if (book != null) {
            player.sendSystemMessage((Component)Component.translatable((String)"modonomicon.command.success.load_progress", (Object[])new Object[]{Component.translatable((String)book.getName())}));
        } else {
            player.sendSystemMessage((Component)Component.translatable((String)"modonomicon.command.error.load_progress").withStyle(ChatFormatting.RED));
        }
    }
}

