/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.api.client.model.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;

public class NTArmorModel
extends HumanoidArmorModel<LivingEntity> {
    private final EquipmentSlot slot;

    public NTArmorModel(ModelPart root, EquipmentSlot slot) {
        super(root);
        this.slot = slot;
    }

    public static LayerDefinition createLayer(int textureWidth, int textureHeight, Consumer<PartsDefinition> partsConsumer) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.ZERO);
        partsConsumer.accept(new PartsDefinition(root));
        return LayerDefinition.create((MeshDefinition)mesh, (int)textureWidth, (int)textureHeight);
    }

    public void setupAnim(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.setPartVisibility(this.slot);
        super.renderToBuffer(poseStack, buffer, packedLight, packedOverlay, color);
    }

    protected void setPartVisibility(EquipmentSlot slot) {
        this.setAllVisible(false);
        switch (slot) {
            case HEAD: {
                this.head.visible = true;
                this.hat.visible = true;
                break;
            }
            case CHEST: {
                this.body.visible = true;
                this.rightArm.visible = true;
                this.leftArm.visible = true;
                break;
            }
            case LEGS: {
                this.body.visible = true;
                this.rightLeg.visible = true;
                this.leftLeg.visible = true;
                break;
            }
            case FEET: {
                this.rightLeg.visible = true;
                this.leftLeg.visible = true;
            }
        }
    }

    public record PartsDefinition(PartDefinition root) {
        public PartDefinition getHat() {
            return this.root().addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        }

        public PartDefinition getHead() {
            return this.root().addOrReplaceChild("head", CubeListBuilder.create(), PartPose.ZERO);
        }

        public PartDefinition getBody() {
            return this.root().addOrReplaceChild("body", CubeListBuilder.create(), PartPose.ZERO);
        }

        public PartDefinition getLeftArm() {
            return this.root().addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.ZERO);
        }

        public PartDefinition getRightArm() {
            return this.root().addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.ZERO);
        }

        public PartDefinition getLeftLeg() {
            return this.root().addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.ZERO);
        }

        public PartDefinition getRightLeg() {
            return this.root().addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.ZERO);
        }
    }
}

