/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.api.client.renderer.blockentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.api.client.renderer.blockentities.NTBERenderer;
import com.portingdeadmods.nautec.utils.LaserRendererHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LaserBlockEntityRenderer<T extends LaserBlockEntity>
extends NTBERenderer<T> {
    public LaserBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Override
    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Object2IntMap<Direction> laserDistances = ((LaserBlockEntity)((Object)blockEntity)).getLaserDistances();
        for (Direction direction : ((LaserBlockEntity)((Object)blockEntity)).getLaserOutputs()) {
            int laserDistance = laserDistances.getOrDefault((Object)direction, 0);
            BlockPos originPos = blockEntity.getBlockPos();
            BlockPos targetPos = originPos.relative(direction, laserDistance - 1);
            BlockState state = blockEntity.getLevel().getBlockState(targetPos.relative(direction));
            if (laserDistance <= 0 || !((LaserBlockEntity)((Object)blockEntity)).shouldRender(direction)) continue;
            VoxelShape shape = state.getShape((BlockGetter)blockEntity.getLevel(), targetPos.relative(direction), CollisionContext.empty());
            float shapeIndent = switch (direction.getAxisDirection()) {
                default -> throw new MatchException(null, null);
                case Direction.AxisDirection.POSITIVE -> (float)shape.min(direction.getAxis());
                case Direction.AxisDirection.NEGATIVE -> (float)shape.max(direction.getAxis());
            };
            LaserRendererHelper.renderOuterBeam(blockEntity, originPos, targetPos, 1.0f - shapeIndent, direction, poseStack, bufferSource, partialTick);
            poseStack.pushPose();
            poseStack.mulPose(direction.getRotation());
            poseStack.scale(0.125f, 1.0f, 0.125f);
            switch (direction) {
                case UP: {
                    poseStack.translate(3.5f, 0.0f, 3.5f);
                    break;
                }
                case DOWN: 
                case SOUTH: 
                case WEST: {
                    poseStack.translate(3.5f, 0.0f, -4.5f);
                    break;
                }
                case EAST: 
                case NORTH: {
                    poseStack.translate(-4.5f, 0.0f, -4.5f);
                }
            }
            int offset = 0;
            int offset2 = 0;
            if (direction == Direction.EAST || direction == Direction.SOUTH) {
                offset2 = 1;
            }
            if (direction == Direction.NORTH || direction == Direction.WEST) {
                offset2 = 1;
            }
            if (direction == Direction.DOWN) {
                offset2 = 1;
            }
            if (direction == Direction.UP) {
                offset = 1;
                offset2 = 1;
            }
            LaserRendererHelper.renderInnerBeam(poseStack, bufferSource, partialTick, blockEntity.getLevel().getGameTime(), offset, (float)(laserDistance - offset - offset2) + (1.0f - shapeIndent), FastColor.ARGB32.color((int)202, (int)214, (int)224));
            poseStack.popPose();
        }
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    @NotNull
    public AABB getRenderBoundingBox(T blockEntity) {
        BlockPos blockPos = blockEntity.getBlockPos();
        AABB box = new AABB(blockPos);
        Object2IntMap<Direction> laserDistances = ((LaserBlockEntity)((Object)blockEntity)).getLaserDistances();
        for (Direction direction : ((LaserBlockEntity)((Object)blockEntity)).getLaserOutputs()) {
            int distance = laserDistances.getOrDefault((Object)direction, 0);
            BlockPos pos = blockPos.relative(direction, distance);
            BlockPos relative = blockPos.subtract((Vec3i)pos);
            box = box.expandTowards((double)(-relative.getX()), (double)(-relative.getY()), (double)(-relative.getZ()));
        }
        return box;
    }
}

