/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.api.client.screen;

import com.portingdeadmods.nautec.Nautec;
import com.portingdeadmods.nautec.api.bacteria.BacteriaInstance;
import com.portingdeadmods.nautec.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.nautec.api.menu.NTMachineMenu;
import com.portingdeadmods.nautec.api.menu.slots.SlotBacteriaStorage;
import com.portingdeadmods.nautec.api.menu.slots.SlotFluidHandler;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.bacteria.IBacteriaStorage;
import com.portingdeadmods.nautec.network.BacteriaSlotClickedPayload;
import com.portingdeadmods.nautec.registries.NTItems;
import com.portingdeadmods.nautec.utils.GuiUtils;
import java.text.NumberFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class NTMachineScreen<T extends ContainerBlockEntity>
extends AbstractContainerScreen<NTMachineMenu<T>> {
    private SlotFluidHandler hoveredFluidHandlerSlot;
    private SlotBacteriaStorage hoveredBacteriaStorageSlot;
    private final NumberFormat nf = NumberFormat.getIntegerInstance();

    public NTMachineScreen(NTMachineMenu<T> menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.titleLabelY = 4;
        this.imageHeight = 174;
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pGuiGraphics, pMouseX, pMouseX, pPartialTick);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        this.hoverFluidSlot(pMouseX, pMouseY);
        this.hoverBacteriaSlot(pGuiGraphics, pMouseX, pMouseY);
        Font font = this.minecraft.font;
        SlotBacteriaStorage slot = this.hoveredBacteriaStorageSlot;
        if (slot != null) {
            BacteriaInstance bacteria = slot.getBacteriaStorage().getBacteria(slot.getSlot());
            if (!bacteria.isEmpty()) {
                List<Component> tooltip = bacteria.getTooltip();
                pGuiGraphics.renderComponentTooltip(font, tooltip, pMouseX, pMouseY);
            }
            int color = FastColor.ARGB32.color((int)20, (int)30, (int)30, (int)30);
            pGuiGraphics.fillGradient(this.leftPos + slot.getX() + 2, this.topPos + slot.getY() + 2, this.leftPos + slot.getX() + slot.getWidth() - 2, this.topPos + slot.getY() + slot.getHeight() - 2, color, color);
        }
        if (this.hoveredFluidHandlerSlot != null) {
            FluidStack fluid = this.hoveredFluidHandlerSlot.getFluidStack();
            pGuiGraphics.renderComponentTooltip(font, List.of(fluid.getHoverName(), Component.literal((String)"%s / %s mb".formatted(this.nf.format(fluid.getAmount()), this.nf.format(this.hoveredFluidHandlerSlot.getFluidCapacity()))).withStyle(ChatFormatting.GRAY)), pMouseX, pMouseY);
        }
        for (SlotBacteriaStorage bSlot : ((NTMachineMenu)this.menu).getBacteriaStorageSlots()) {
            GuiUtils.renderBacteria(pGuiGraphics, bSlot.getBacteriaInstance(), this.leftPos + bSlot.getX(), this.topPos + bSlot.getY());
        }
        for (SlotFluidHandler fSlot : ((NTMachineMenu)this.menu).getFluidTankSlots()) {
            fSlot.getRenderer().render(pGuiGraphics.pose(), this.leftPos + fSlot.getX(), this.topPos + fSlot.getY(), fSlot.getFluidStack());
        }
    }

    private void hoverFluidSlot(int pMouseX, int pMouseY) {
        for (SlotFluidHandler fSlot : ((NTMachineMenu)this.menu).getFluidTankSlots()) {
            if (!this.isHovering(fSlot.getX(), fSlot.getY(), fSlot.getWidth(), fSlot.getHeight(), pMouseX, pMouseY)) continue;
            this.hoveredFluidHandlerSlot = fSlot;
            return;
        }
        this.hoveredFluidHandlerSlot = null;
    }

    private void hoverBacteriaSlot(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        for (SlotBacteriaStorage bSlot : ((NTMachineMenu)this.menu).getBacteriaStorageSlots()) {
            if (!this.isHovering(bSlot.getX(), bSlot.getY(), bSlot.getWidth(), bSlot.getHeight(), pMouseX, pMouseY)) continue;
            this.hoveredBacteriaStorageSlot = bSlot;
            Nautec.LOGGER.debug("Slot: {}", (Object)bSlot.getSlot());
            return;
        }
        this.hoveredBacteriaStorageSlot = null;
    }

    protected void renderBg(GuiGraphics guiGraphics, float delta, int mouseX, int mouseY) {
        guiGraphics.blit(this.getBackgroundTexture(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    @NotNull
    public abstract ResourceLocation getBackgroundTexture();

    public SlotFluidHandler getHoveredFluidHandlerSlot() {
        return this.hoveredFluidHandlerSlot;
    }

    public SlotBacteriaStorage getHoveredBacteriaStorageSlot() {
        return this.hoveredBacteriaStorageSlot;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        ItemStack carried = ((NTMachineMenu)this.menu).getCarried();
        SlotBacteriaStorage slot = this.getHoveredBacteriaStorageSlot();
        if (carried.is(NTItems.PETRI_DISH) && slot != null) {
            Nautec.LOGGER.debug("index: {}", (Object)slot.getSlot());
            IBacteriaStorage itemStorage = (IBacteriaStorage)carried.getCapability(NTCapabilities.BacteriaStorage.ITEM);
            PacketDistributor.sendToServer((CustomPacketPayload)new BacteriaSlotClickedPayload(((NTMachineMenu)this.menu).blockEntity.getBlockPos(), slot.getSlot(), itemStorage.getBacteria(0)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

