/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.api.fluids;

import com.portingdeadmods.nautec.api.fluids.BaseFluidType;
import com.portingdeadmods.nautec.api.fluids.FluidTemplate;
import java.util.function.Supplier;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredItem;
import org.joml.Vector4i;

public abstract class NTFluid {
    public Supplier<BaseFlowingFluid.Source> stillFluid = () -> new BaseFlowingFluid.Source(this.fluidProperties());
    public Supplier<BaseFlowingFluid.Flowing> flowingFluid = () -> new BaseFlowingFluid.Flowing(this.fluidProperties());
    public Supplier<FluidType> fluidType;
    public Supplier<LiquidBlock> block;
    public Supplier<BucketItem> bucket;
    public DeferredItem<BucketItem> deferredBucket;
    protected BaseFlowingFluid.Properties properties;
    protected final String name;

    public NTFluid(String name) {
        this.name = name;
    }

    public BlockBehaviour.Properties blockProperties() {
        return BlockBehaviour.Properties.of();
    }

    public BaseFlowingFluid.Properties fluidProperties() {
        return new BaseFlowingFluid.Properties(this.fluidType, this.stillFluid, this.flowingFluid);
    }

    public BaseFlowingFluid.Source getStillFluid() {
        return this.stillFluid.get();
    }

    public BaseFlowingFluid.Flowing getFlowingFluid() {
        return this.flowingFluid.get();
    }

    public Supplier<FluidType> getFluidType() {
        return this.fluidType;
    }

    public Item getBucket() {
        return (Item)this.getDeferredBucket().get();
    }

    public DeferredItem<BucketItem> getDeferredBucket() {
        return this.deferredBucket;
    }

    public String getName() {
        return this.name;
    }

    public Supplier<FluidType> registerFluidType(FluidType.Properties properties, Vector4i color, FluidTemplate template) {
        return () -> new BaseFluidType(template.getStillTexture(), template.getFlowingTexture(), template.getOverlayTexture(), color, properties);
    }
}

