/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.capabilities.bacteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.nautec.Nautec;
import com.portingdeadmods.nautec.api.bacteria.BacteriaInstance;
import com.portingdeadmods.nautec.capabilities.bacteria.IBacteriaStorage;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class BacteriaStorage
implements IBacteriaStorage,
INBTSerializable<Tag> {
    private static final Codec<BacteriaStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BacteriaInstance.CODEC.listOf().fieldOf("bacteria").forGetter(BacteriaStorage::getBacteria), (App)Codec.INT.fieldOf("slots").forGetter(BacteriaStorage::getBacteriaSlots)).apply((Applicative)instance, BacteriaStorage::new));
    private NonNullList<BacteriaInstance> bacteria;
    private int slots;

    public BacteriaStorage(int slots) {
        this.bacteria = NonNullList.withSize((int)slots, (Object)BacteriaInstance.EMPTY);
        this.slots = slots;
    }

    private BacteriaStorage(List<BacteriaInstance> bacteria, int slots) {
        this(slots);
        for (int i = 0; i < bacteria.size(); ++i) {
            BacteriaInstance instance = bacteria.get(i);
            this.bacteria.set(i, (Object)instance);
        }
    }

    public @UnknownNullability Tag serializeNBT(HolderLookup.Provider provider) {
        DataResult tagDataResult = CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this);
        if (tagDataResult.isSuccess()) {
            return (Tag)tagDataResult.result().get();
        }
        Nautec.LOGGER.error("Error encoding BacteriaStorage: {}", (Object)((DataResult.Error)tagDataResult.error().get()).message());
        return null;
    }

    public void deserializeNBT(HolderLookup.Provider provider, Tag nbt) {
        DataResult dataResult = CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt);
        if (dataResult.isSuccess()) {
            BacteriaStorage newThis = (BacteriaStorage)((Pair)dataResult.getOrThrow()).getFirst();
            this.bacteria = newThis.bacteria;
            this.slots = newThis.slots;
        } else {
            Nautec.LOGGER.error("Error decoding BacteriaStorage: {}", (Object)((DataResult.Error)dataResult.error().get()).message());
        }
    }

    public NonNullList<BacteriaInstance> getBacteria() {
        return this.bacteria;
    }

    @Override
    public void setBacteria(int slot, BacteriaInstance bacteriaInstance) {
        this.bacteria.set(slot, (Object)bacteriaInstance);
    }

    @Override
    public BacteriaInstance getBacteria(int slot) {
        return (BacteriaInstance)this.bacteria.get(slot);
    }

    @Override
    public int getBacteriaSlots() {
        return this.slots;
    }
}

