/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.capabilities.bacteria;

import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.api.bacteria.BacteriaInstance;
import com.portingdeadmods.nautec.api.bacteria.CollapsedBacteriaStats;
import java.util.function.UnaryOperator;

public interface IBacteriaStorage {
    public void setBacteria(int var1, BacteriaInstance var2);

    public BacteriaInstance getBacteria(int var1);

    public int getBacteriaSlots();

    default public void onBacteriaChanged(int slot) {
    }

    default public void modifyStats(int slot, UnaryOperator<CollapsedBacteriaStats> statsModifier) {
        BacteriaInstance bacteriaInstance = this.getBacteria(slot);
        CollapsedBacteriaStats newStats = (CollapsedBacteriaStats)statsModifier.apply(bacteriaInstance.getStats());
        bacteriaInstance.setStats(newStats);
    }

    default public BacteriaInstance insertBacteria(int slot, BacteriaInstance instance, boolean simulate) {
        if (instance.isEmpty()) {
            return BacteriaInstance.EMPTY;
        }
        BacteriaInstance bacteriaInSlot = this.getBacteria(slot);
        if (bacteriaInSlot.isEmpty()) {
            long amount = Math.min(NTConfig.bacteriaColonySizeCap, instance.getSize());
            if (!simulate) {
                this.setBacteria(slot, instance.copyWithSize(amount));
                this.onBacteriaChanged(slot);
            }
            return instance.copyWithSize(instance.getSize() - amount);
        }
        if (BacteriaInstance.isSameBacteriaAndStats(bacteriaInSlot, instance)) {
            long rawAmount = bacteriaInSlot.getSize() + instance.getSize();
            long amount = Math.min(NTConfig.bacteriaColonySizeCap, rawAmount);
            if (!simulate) {
                this.setBacteria(slot, instance.copyWithSize(amount));
                this.onBacteriaChanged(slot);
            }
            return instance.copyWithSize(rawAmount - amount);
        }
        return instance.copy();
    }

    default public BacteriaInstance extractBacteria(int slot, long amount, boolean simulate) {
        BacteriaInstance instance = this.getBacteria(slot);
        if (amount <= 0L || instance.isEmpty()) {
            return BacteriaInstance.EMPTY;
        }
        long toExtract = Math.min(amount, NTConfig.bacteriaColonySizeCap);
        if (instance.getSize() <= toExtract) {
            if (!simulate) {
                this.setBacteria(slot, BacteriaInstance.EMPTY);
                this.onBacteriaChanged(slot);
                return instance;
            }
            return instance.copy();
        }
        if (!simulate) {
            this.setBacteria(slot, instance.copyWithSize(instance.getSize() - toExtract));
            this.onBacteriaChanged(slot);
        }
        return instance.copyWithSize(toExtract);
    }
}

