/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.capabilities.fluid;

import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.utils.Utils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntList;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public record TwoTankSidedFluidHandler(IFluidHandler primaryHandler, IFluidHandler secondaryHandler, IOActions action, IntList tanks) implements IFluidHandler
{
    public TwoTankSidedFluidHandler(IFluidHandler primaryHandler, IFluidHandler secondaryHandler, Pair<IOActions, int[]> actionSlotsPair) {
        this(primaryHandler, secondaryHandler, actionSlotsPair != null ? (IOActions)((Object)actionSlotsPair.left()) : IOActions.NONE, actionSlotsPair != null ? Utils.intArrayToList((int[])actionSlotsPair.right()) : IntList.of());
    }

    public int getTanks() {
        return 2;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return tank == 0 ? this.primaryHandler.getFluidInTank(0) : this.secondaryHandler.getFluidInTank(0);
    }

    public int getTankCapacity(int tank) {
        return tank == 0 ? this.primaryHandler.getTankCapacity(0) : this.secondaryHandler.getTankCapacity(0);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return (this.action == IOActions.INSERT || this.action == IOActions.BOTH) && this.tanks.contains(tank) && (tank == 0 ? this.primaryHandler.isFluidValid(0, stack) : this.secondaryHandler.isFluidValid(0, stack));
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction fAction) {
        return this.action == IOActions.INSERT || this.action == IOActions.BOTH ? this.primaryHandler.fill(resource, fAction) : 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction fAction) {
        if (this.action != IOActions.EXTRACT && this.action != IOActions.BOTH) {
            return FluidStack.EMPTY;
        }
        FluidStack currentFluid = this.secondaryHandler.getFluidInTank(0);
        if (currentFluid.isEmpty() || !currentFluid.is(resource.getFluid()) || currentFluid.getAmount() < resource.getAmount()) {
            return FluidStack.EMPTY;
        }
        return this.secondaryHandler.drain(resource, fAction);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction fAction) {
        if (this.action != IOActions.EXTRACT && this.action != IOActions.BOTH) {
            return FluidStack.EMPTY;
        }
        FluidStack currentFluid = this.secondaryHandler.getFluidInTank(0);
        if (currentFluid.isEmpty() || currentFluid.getAmount() < maxDrain) {
            return FluidStack.EMPTY;
        }
        return this.secondaryHandler.drain(maxDrain, fAction);
    }
}

