/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.capabilities.power;

import com.portingdeadmods.nautec.api.items.IPowerItem;
import com.portingdeadmods.nautec.capabilities.power.IPowerStorage;
import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.data.components.ComponentPowerStorage;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Range;

public record ItemPowerWrapper(ItemStack itemStack, IPowerItem powerItem) implements IPowerStorage
{
    public ItemPowerWrapper {
        if (!itemStack.has(NTDataComponents.POWER)) {
            throw new IllegalStateException("The item: " + String.valueOf(itemStack.getItem()) + " is missing the Power Datacomponent");
        }
    }

    private ComponentPowerStorage getComponent() {
        return (ComponentPowerStorage)this.itemStack.getOrDefault(NTDataComponents.POWER, (Object)ComponentPowerStorage.EMPTY);
    }

    private void setComponent(ComponentPowerStorage powerStorage) {
        this.itemStack.set(NTDataComponents.POWER, (Object)powerStorage);
    }

    @Override
    public void onEnergyChanged() {
        IPowerStorage.super.onEnergyChanged();
        this.powerItem.onEnergyChanged(this.itemStack);
    }

    @Override
    public int getPowerStored() {
        return this.getComponent().powerStored();
    }

    @Override
    public int getPowerCapacity() {
        return this.getComponent().powerCapacity();
    }

    @Override
    public @Range(from=0L, to=1L) float getPurity() {
        return this.getComponent().purity();
    }

    @Override
    public void setPowerStored(int powerStored) {
        if (this.getPowerStored() != powerStored) {
            this.onEnergyChanged();
            this.setComponent(new ComponentPowerStorage(powerStored, this.getComponent().powerCapacity(), this.getComponent().purity()));
        }
    }

    @Override
    public void setPowerCapacity(int powerCapacity) {
        this.setComponent(new ComponentPowerStorage(this.getComponent().powerStored(), powerCapacity, this.getComponent().purity()));
    }

    @Override
    public void setPurity(float purity) {
        this.setComponent(new ComponentPowerStorage(this.getComponent().powerStored(), this.getComponent().powerCapacity(), purity));
    }

    @Override
    public int getMaxInput() {
        return this.powerItem.getMaxInput();
    }

    @Override
    public int getMaxOutput() {
        return this.powerItem.getMaxOutput();
    }
}

