/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.client.model.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class AnchorModel
extends Model {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"anchor"), "main");
    public static final Material MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"entity/anchor"));
    private final ModelPart anchor;
    private final ModelPart rod;
    private final ModelPart bottom;

    public AnchorModel(ModelPart root) {
        super(RenderType::entitySolid);
        this.anchor = root.getChild("anchor");
        this.rod = this.anchor.getChild("rod");
        this.bottom = this.anchor.getChild("bottom");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition anchor = partdefinition.addOrReplaceChild("anchor", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.0f, (float)21.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition rod = anchor.addOrReplaceChild("rod", CubeListBuilder.create().texOffs(16, 8).addBox(-10.0f, -37.0f, -2.0f, 8.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(16, 15).addBox(2.0f, -37.0f, -2.0f, 8.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(16, 36).addBox(-4.0f, -43.0f, -2.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 43).addBox(-4.0f, -47.0f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(40, 8).addBox(-4.0f, -49.0f, -2.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(40, 44).addBox(2.0f, -47.0f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.0f, -41.0f, -2.0f, 4.0f, 39.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)0.0f, (float)0.0f));
        PartDefinition bottom = anchor.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(16, 0).addBox(-7.0f, -2.0f, -2.0f, 14.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(40, 14).addBox(7.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(16, 22).addBox(11.0f, -12.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(16, 42).addBox(11.0f, -16.0f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(28, 42).addBox(-13.0f, -16.0f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(40, 36).addBox(-11.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(32, 22).addBox(-15.0f, -12.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim() {
        this.anchor.xRot = (float)Math.toRadians(180.0);
        this.anchor.x = 0.0f;
        this.anchor.y = 0.0f;
        this.anchor.z = 0.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.anchor.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

