/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.client.model.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class RobotArmModel
extends Model {
    public static final Material ROBOT_ARM_LOCATION = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"entity/robot_arm"));
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"robot_arm"), "main");
    private final ModelPart main;
    private final ModelPart bottom;
    private final ModelPart middle;
    private final ModelPart tip;

    public RobotArmModel(ModelPart root) {
        super(RenderType::entitySolid);
        this.main = root.getChild("main");
        this.bottom = this.main.getChild("bottom");
        this.middle = this.main.getChild("middle");
        this.tip = this.main.getChild("tip");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition main = partdefinition.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bottom = main.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(8, 0).addBox(-1.0f, -16.0f, -1.0f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition middle = main.addOrReplaceChild("middle", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -30.0f, -1.0f, 2.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 0).addBox(-1.0f, -6.0f, -2.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)0.0f, (float)0.0021f, (float)-7.0E-4f, (float)-1.0E-4f));
        PartDefinition tip = main.addOrReplaceChild("tip", CubeListBuilder.create().texOffs(16, 9).addBox(-2.0f, -32.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 18).addBox(1.0f, -32.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 6).addBox(-2.0f, -29.0f, -1.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(12, 14).addBox(-1.0f, -28.0f, -2.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-16.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.625, 0.5);
        poseStack.mulPose(Axis.XP.rotation((float)Math.toRadians(180.0)));
        this.tip.render(poseStack, buffer, packedLight, packedOverlay);
        this.middle.render(poseStack, buffer, packedLight, packedOverlay);
        this.bottom.render(poseStack, buffer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public void renderPart(RobotArmParts part, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        (switch (part.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> this.bottom;
            case 1 -> this.middle;
            case 0 -> this.tip;
        }).render(poseStack, buffer, packedLight, packedOverlay);
    }

    public static enum RobotArmParts {
        TIP,
        MIDDLE,
        BOTTOM;

    }
}

