/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.client.renderer.augments.helper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.portingdeadmods.nautec.content.augments.GuardianEyeAugment;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class GuardianEyeRenderHelper {
    private static final ResourceLocation GUARDIAN_BEAM_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/guardian_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)GUARDIAN_BEAM_LOCATION);

    public static void render(Player entity, GuardianEyeAugment augment, float partialTicks, PoseStack poseStack, MultiBufferSource buffer) {
        Entity targetEntity = augment.getTargetEntity();
        if (targetEntity == null) {
            return;
        }
        float laserScale = augment.getLaserScale(partialTicks);
        float laserTime = augment.getClientLaserTime() + partialTicks;
        float laserProgress = laserTime * 0.5f % 1.0f;
        float eyeHeight = entity.getEyeHeight();
        poseStack.pushPose();
        poseStack.translate(0.0f, eyeHeight, 0.0f);
        Vec3 targetPos = GuardianEyeRenderHelper.getPosition(targetEntity, (double)targetEntity.getBbHeight() * 0.5, partialTicks);
        Vec3 entityPos = GuardianEyeRenderHelper.getPosition((Entity)entity, eyeHeight, partialTicks);
        Vec3 direction = targetPos.subtract(entityPos).normalize();
        float distance = (float)(targetPos.subtract(entityPos).length() + 1.0);
        float pitch = (float)Math.acos(direction.y);
        float yaw = (float)Math.atan2(direction.z, direction.x);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f - yaw * 57.295776f));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch * 57.295776f));
        float wobble = laserTime * 0.05f * -1.5f;
        float intensity = laserScale * laserScale;
        int red = 64 + (int)(intensity * 191.0f);
        int green = 32 + (int)(intensity * 191.0f);
        int blue = 128 - (int)(intensity * 64.0f);
        float halfPi = 1.5707964f;
        float[] cosines = new float[]{Mth.cos((float)wobble), Mth.cos((float)(wobble + halfPi)), Mth.cos((float)((float)((double)wobble + Math.PI))), Mth.cos((float)(wobble + 4.712389f))};
        float[] sines = new float[]{Mth.sin((float)wobble), Mth.sin((float)(wobble + halfPi)), Mth.sin((float)((float)((double)wobble + Math.PI))), Mth.sin((float)(wobble + 4.712389f))};
        VertexConsumer vertexConsumer = buffer.getBuffer(BEAM_RENDER_TYPE);
        PoseStack.Pose pose = poseStack.last();
        for (int i = 0; i < 4; ++i) {
            int next = (i + 1) % 4;
            float u1 = i < 2 ? 0.0f : 0.5f;
            float u2 = next < 2 ? 0.0f : 0.5f;
            GuardianEyeRenderHelper.vertex(vertexConsumer, pose, cosines[i] * 0.2f, distance, sines[i] * 0.2f, red, green, blue, u1, laserProgress + distance);
            GuardianEyeRenderHelper.vertex(vertexConsumer, pose, cosines[i] * 0.2f, 0.0f, sines[i] * 0.2f, red, green, blue, u1, laserProgress);
            GuardianEyeRenderHelper.vertex(vertexConsumer, pose, cosines[next] * 0.2f, 0.0f, sines[next] * 0.2f, red, green, blue, u2, laserProgress);
            GuardianEyeRenderHelper.vertex(vertexConsumer, pose, cosines[next] * 0.2f, distance, sines[next] * 0.2f, red, green, blue, u2, laserProgress + distance);
        }
        poseStack.popPose();
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float z, int red, int green, int blue, float u, float v) {
        consumer.addVertex(pose, x, y, z).setColor(red, green, blue, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    private static Vec3 getPosition(Entity livingEntity, double yOffset, float partialTick) {
        double d0 = Mth.lerp((double)partialTick, (double)livingEntity.xOld, (double)livingEntity.getX());
        double d1 = Mth.lerp((double)partialTick, (double)livingEntity.yOld, (double)livingEntity.getY()) + yOffset;
        double d2 = Mth.lerp((double)partialTick, (double)livingEntity.zOld, (double)livingEntity.getZ());
        return new Vec3(d0, d1, d2);
    }
}

