/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.client.renderer.blockentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.portingdeadmods.nautec.api.client.renderer.blockentities.LaserBlockEntityRenderer;
import com.portingdeadmods.nautec.client.model.block.PrismarineCrystalModel;
import com.portingdeadmods.nautec.content.blockentities.multiblock.semi.PrismarineCrystalBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class PrismarineCrystalBERenderer
extends LaserBlockEntityRenderer<PrismarineCrystalBlockEntity> {
    private final PrismarineCrystalModel model;

    public PrismarineCrystalBERenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new PrismarineCrystalModel(ctx.bakeLayer(PrismarineCrystalModel.LAYER_LOCATION));
        this.model.setupAnim();
    }

    @Override
    public void render(PrismarineCrystalBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float f;
        super.render(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        VertexConsumer consumer = PrismarineCrystalModel.PRISMARINE_CRYSTAL_LOCATION.buffer(bufferSource, RenderType::entitySolid);
        poseStack.pushPose();
        poseStack.translate(0.0f, -2.0f, 0.0f);
        if (blockEntity.isBreaking() && (f = ((float)(blockEntity.getLevel().getGameTime() - blockEntity.getStartTick()) + partialTick) / (float)blockEntity.getDuration()) >= 0.0f && f <= 1.0f) {
            float f2 = f * ((float)Math.PI * 2);
            float f3 = -1.5f * (Mth.cos((float)f2) + 0.5f) * Mth.sin((float)(f2 / 2.0f));
            poseStack.rotateAround(Axis.XP.rotation(f3 * 0.015625f), 0.5f, 0.0f, 0.5f);
            float f4 = Mth.sin((float)f2);
            poseStack.rotateAround(Axis.ZP.rotation(f4 * 0.015625f), 0.5f, 0.0f, 0.5f);
        }
        this.model.render(poseStack, consumer, this.getLightLevel(blockEntity.getLevel(), blockEntity.getBlockPos().above()), packedOverlay);
        poseStack.popPose();
    }

    private int getLightLevel(Level level, BlockPos pos) {
        return LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos);
    }

    @Override
    @NotNull
    public AABB getRenderBoundingBox(PrismarineCrystalBlockEntity blockEntity) {
        return blockEntity.shouldRender(Direction.UP) ? super.getRenderBoundingBox(blockEntity) : new AABB(blockEntity.getBlockPos().below(3)).expandTowards(0.0, 6.0, 0.0);
    }
}

