/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.compat.jei.categories;

import com.portingdeadmods.nautec.api.bacteria.BacteriaInstance;
import com.portingdeadmods.nautec.capabilities.NTCapabilities;
import com.portingdeadmods.nautec.capabilities.bacteria.IBacteriaStorage;
import com.portingdeadmods.nautec.data.maps.BacteriaObtainValue;
import com.portingdeadmods.nautec.registries.NTItems;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BacteriaGraftingCategory
implements IRecipeCategory<GraftingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"grafting");
    public static final RecipeType<GraftingRecipe> RECIPE_TYPE = new RecipeType(UID, GraftingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public BacteriaGraftingCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(132, 42);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)NTItems.GRAFTING_TOOL.get()));
    }

    public RecipeType<GraftingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.literal((String)"Bacteria Grafting");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GraftingRecipe recipe, IFocusGroup focuses) {
        int y = 6;
        builder.addInputSlot(0, this.getHeight() / 2 - 9 + y).addItemLike(NTItems.PETRI_DISH);
        ItemStack stack = NTItems.PETRI_DISH.toStack();
        IBacteriaStorage bacteriaStorage = (IBacteriaStorage)stack.getCapability(NTCapabilities.BacteriaStorage.ITEM);
        bacteriaStorage.setBacteria(0, BacteriaInstance.withMaxStats(recipe.val.bacteria(), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
        builder.addOutputSlot(this.getWidth() - 18, this.getHeight() / 2 - 9 + y).addItemStack(stack);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, this.getWidth() / 2 - 9, this.getHeight() / 2 - 18 + y).addItemLike(NTItems.GRAFTING_TOOL);
        builder.addSlot(RecipeIngredientRole.INPUT, this.getWidth() / 2 - 9, this.getHeight() / 2 + y).addItemLike((ItemLike)recipe.block());
    }

    public void draw(GraftingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.getInstance().font;
        guiGraphics.drawString(font, (Component)Component.literal((String)"Only In: ").append(recipe.val.biome().location().toString()), 0, 0, ChatFormatting.DARK_GRAY.getColor().intValue(), false);
    }

    public record GraftingRecipe(Block block, BacteriaObtainValue val) {
        public static final String NAME = "grafting";
    }
}

