/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.compat.jei.categories;

import com.portingdeadmods.nautec.content.recipes.MixingRecipe;
import com.portingdeadmods.nautec.content.recipes.utils.RecipeUtils;
import com.portingdeadmods.nautec.registries.NTBlocks;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class MixingRecipeCategory
implements IRecipeCategory<MixingRecipe> {
    static final ResourceLocation SINGLE_SLOT_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"container/furnace/empty_slot");
    static final ResourceLocation DOWN_ARROW_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"container/furnace/down_arrow");
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)"mixing");
    public static final RecipeType<MixingRecipe> RECIPE_TYPE = new RecipeType(UID, MixingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final Object2ObjectMap<MixingRecipe, Vector2i[]> slotPositions = new Object2ObjectOpenHashMap();

    public MixingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(106, 66);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)NTBlocks.MIXER.get()));
    }

    public RecipeType<MixingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.literal((String)"Mixing");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MixingRecipe recipe, IFocusGroup focuses) {
        int maxSlots = 4;
        int slotSize = 18;
        int gap = 2;
        Vector2i[] slots = new Vector2i[recipe.getIngredients().size() + 1];
        if (!recipe.getIngredients().isEmpty()) {
            int totalSlotWidth = Math.min(recipe.getIngredients().size(), maxSlots) * slotSize + (Math.min(recipe.getIngredients().size(), maxSlots) - 1) * gap;
            int startX = (80 - totalSlotWidth) / 2;
            for (int i = 0; i < recipe.getIngredients().size(); ++i) {
                int x = startX + i * (slotSize + gap);
                int y = 0;
                builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(RecipeUtils.iWCToIngredientSaveCount(recipe.ingredients().get(i)));
                slots[i] = new Vector2i(x, y);
            }
        }
        if (recipe.result() != null) {
            int outputSlotSize = 18;
            int outputX = (80 - outputSlotSize) / 2;
            builder.addSlot(RecipeIngredientRole.OUTPUT, outputX, 50).addItemStack(recipe.result());
            slots[recipe.getIngredients().size()] = new Vector2i(outputX, 50);
        }
        if (recipe.fluidIngredient().getFluid() != Fluids.EMPTY) {
            builder.addSlot(RecipeIngredientRole.INPUT, 88, 0).addFluidStack(recipe.fluidIngredient().getFluid(), (long)recipe.fluidIngredient().getAmount()).setFluidRenderer((long)recipe.fluidIngredient().getAmount(), true, 16, 16);
        }
        if (recipe.fluidResult().getFluid() != Fluids.EMPTY) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 88, 48).addFluidStack(recipe.fluidResult().getFluid(), (long)recipe.fluidResult().getAmount()).setFluidRenderer((long)recipe.fluidResult().getAmount(), true, 16, 16);
        }
        this.slotPositions.put((Object)recipe, (Object)slots);
    }

    public void draw(@NotNull MixingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        for (Vector2i slotPos : (Vector2i[])this.slotPositions.get((Object)recipe)) {
            int x = slotPos.x;
            int y = slotPos.y;
            guiGraphics.blitSprite(SINGLE_SLOT_SPRITE, x - 1, y - 1, 18, 18);
        }
        guiGraphics.blitSprite(SINGLE_SLOT_SPRITE, 87, -1, 18, 18);
        guiGraphics.blitSprite(SINGLE_SLOT_SPRITE, 87, 47, 18, 18);
        guiGraphics.blitSprite(DOWN_ARROW_SPRITE, 32, 22, 15, 23);
        guiGraphics.blitSprite(DOWN_ARROW_SPRITE, 88, 22, 15, 23);
    }
}

