/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.augments;

import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.registries.NTAugments;
import java.util.List;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class MagnetAugment
extends Augment {
    private static final double MAGNET_RADIUS = 5.0;
    private static final double MAGNET_PULL_SPEED = 0.2;

    public MagnetAugment(AugmentSlot augmentSlot) {
        super(NTAugments.MAGNET_AUGMENT.get(), augmentSlot);
    }

    @Override
    public void serverTick(PlayerTickEvent.Post event) {
        if (!this.player.isCrouching()) {
            List nearbyItems = this.player.level().getEntitiesOfClass(ItemEntity.class, this.player.getBoundingBox().inflate(5.0));
            for (ItemEntity itemEntity : nearbyItems) {
                Vec3 pullVec = this.player.position().subtract(itemEntity.position()).normalize().scale(0.2);
                itemEntity.setPickUpDelay(0);
                itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add(pullVec));
            }
        }
    }
}

