/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.bacteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.api.bacteria.CollapsedBacteriaStats;
import com.portingdeadmods.nautec.content.bacteria.SimpleBacteriaStats;
import com.portingdeadmods.nautec.utils.ComponentUtils;
import com.portingdeadmods.nautec.utils.MathUtils;
import com.portingdeadmods.nautec.utils.RNGUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class SimpleCollapsedStats
extends Record
implements CollapsedBacteriaStats {
    private final SimpleBacteriaStats baseStats;
    private final float growthRate;
    private final float mutationResistance;
    private final float productionRate;
    private final int lifespan;
    private final int color;
    public static final SimpleCollapsedStats EMPTY = new SimpleCollapsedStats(SimpleBacteriaStats.EMPTY, 0.0f, 0.0f, 0.0f, 0, -1);
    public static final MapCodec<SimpleCollapsedStats> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SimpleBacteriaStats.CODEC.fieldOf("base_stats").forGetter(SimpleCollapsedStats::baseStats), (App)Codec.FLOAT.fieldOf("growth_rate").forGetter(SimpleCollapsedStats::growthRate), (App)Codec.FLOAT.fieldOf("mutation_resistance").forGetter(SimpleCollapsedStats::mutationResistance), (App)Codec.FLOAT.fieldOf("production_rate").forGetter(SimpleCollapsedStats::productionRate), (App)Codec.INT.fieldOf("lifespan").forGetter(SimpleCollapsedStats::lifespan), (App)Codec.INT.fieldOf("color").forGetter(SimpleCollapsedStats::color)).apply((Applicative)instance, SimpleCollapsedStats::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SimpleCollapsedStats> STREAM_CODEC = StreamCodec.composite(SimpleBacteriaStats.STREAM_CODEC, SimpleCollapsedStats::baseStats, (StreamCodec)ByteBufCodecs.FLOAT, SimpleCollapsedStats::growthRate, (StreamCodec)ByteBufCodecs.FLOAT, SimpleCollapsedStats::mutationResistance, (StreamCodec)ByteBufCodecs.FLOAT, SimpleCollapsedStats::productionRate, (StreamCodec)ByteBufCodecs.INT, SimpleCollapsedStats::lifespan, (StreamCodec)ByteBufCodecs.INT, SimpleCollapsedStats::color, SimpleCollapsedStats::new);

    public SimpleCollapsedStats(SimpleBacteriaStats baseStats, float growthRate, float mutationResistance, float productionRate, int lifespan, int color) {
        this.baseStats = baseStats;
        this.growthRate = growthRate;
        this.mutationResistance = mutationResistance;
        this.productionRate = productionRate;
        this.lifespan = lifespan;
        this.color = color;
    }

    public static SimpleCollapsedStats collapse(SimpleBacteriaStats stats) {
        return new SimpleCollapsedStats(stats, RNGUtils.uniformRandFloat(stats.growthRate()), RNGUtils.uniformRandFloat(stats.mutationResistance()), RNGUtils.uniformRandFloat(stats.productionRate()), RNGUtils.uniformRandInt(stats.lifespan()), stats.color());
    }

    public static SimpleCollapsedStats getMaxStats(SimpleBacteriaStats stats) {
        return new SimpleCollapsedStats(stats, NTConfig.bacteriaGrowthRateCap, NTConfig.bacteriaMutationResistanceCap, NTConfig.bacteriaProductionRateCap, NTConfig.bacteriaLifespanCap, stats.color());
    }

    public SimpleBacteriaStats.Serializer getSerializer() {
        return SimpleBacteriaStats.Serializer.INSTANCE;
    }

    public SimpleCollapsedStats rollGrowthRate() {
        float newGR = this.growthRate + RNGUtils.floatInRangeOf(this.growthRate) / (10.0f * (1.0f + this.mutationResistance));
        newGR = Math.max(newGR, 0.0f);
        newGR = Math.min(newGR, NTConfig.bacteriaGrowthRateCap);
        return new SimpleCollapsedStats(this.baseStats, newGR, this.mutationResistance, this.productionRate, this.lifespan, this.color);
    }

    public SimpleCollapsedStats rollMutationResistance() {
        float newMR = this.mutationResistance + RNGUtils.biasedInRange(0.0f, 0.1f, this.mutationResistance / NTConfig.bacteriaMutationResistanceCap) / 10.0f * (NTConfig.bacteriaMutationResistanceCap - this.mutationResistance);
        newMR = Math.max(newMR, 0.0f);
        return new SimpleCollapsedStats(this.baseStats, this.growthRate, newMR, this.productionRate, this.lifespan, this.color);
    }

    public SimpleCollapsedStats rollProductionRate() {
        float newPR = this.productionRate + RNGUtils.floatInRangeOf(this.productionRate) / 10.0f * (1.0f + this.mutationResistance);
        newPR = Math.max(newPR, 0.0f);
        newPR = Math.min(newPR, NTConfig.bacteriaProductionRateCap);
        return new SimpleCollapsedStats(this.baseStats, this.growthRate, this.mutationResistance, newPR, this.lifespan, this.color);
    }

    public SimpleCollapsedStats rollLifespan() {
        int newLS = this.lifespan + (int)((float)RNGUtils.uniformRandInt(-100, 100) / (1.0f + this.mutationResistance));
        newLS = Math.max(newLS, 0);
        newLS = Math.min(newLS, NTConfig.bacteriaLifespanCap);
        return new SimpleCollapsedStats(this.baseStats, this.growthRate, this.mutationResistance, this.productionRate, newLS, this.color);
    }

    @Override
    public SimpleCollapsedStats rollStats() {
        return this.rollGrowthRate().rollMutationResistance().rollProductionRate().rollLifespan();
    }

    public SimpleCollapsedStats grow() {
        return this;
    }

    public SimpleCollapsedStats shrink() {
        return this;
    }

    @Override
    public SimpleCollapsedStats copy() {
        return new SimpleCollapsedStats(this.baseStats, this.growthRate, this.mutationResistance, this.productionRate, this.lifespan, this.color);
    }

    @Override
    public List<Component> statsTooltip() {
        return List.of(ComponentUtils.countableStatShow("Growth Rate", Float.valueOf(this.growthRate), Float.valueOf(NTConfig.bacteriaGrowthRateCap)), ComponentUtils.countableStatShow("Mutation Resistance", Float.valueOf(this.mutationResistance), Float.valueOf(NTConfig.bacteriaMutationResistanceCap)), ComponentUtils.countableStatShow("Production Rate", Float.valueOf(this.productionRate), Float.valueOf(NTConfig.bacteriaProductionRateCap)), ComponentUtils.countableStatShow("Lifespan", this.lifespan, NTConfig.bacteriaLifespanCap));
    }

    @Override
    public List<Component> statsTooltipWithMutatorValues() {
        MutableComponent arrow = ComponentUtils.colored(" -> ", ChatFormatting.YELLOW);
        return List.of(ComponentUtils.countableStatShow("Growth Rate", Float.valueOf(this.growthRate), Float.valueOf(NTConfig.bacteriaGrowthRateCap)).append((Component)arrow).append((Component)ComponentUtils.colored("[", ChatFormatting.GREEN)).append((Component)ComponentUtils.statRange(MathUtils.roundToPrecision(this.growthRate + -this.growthRate / (10.0f * (1.0f + this.mutationResistance)), 2), MathUtils.roundToPrecision(this.growthRate + this.growthRate / (10.0f * (1.0f + this.mutationResistance)), 2), Float.valueOf(NTConfig.bacteriaGrowthRateCap))).append((Component)ComponentUtils.colored("]", ChatFormatting.GREEN)), ComponentUtils.countableStatShow("Mutation Resistance", Float.valueOf(this.mutationResistance), Float.valueOf(NTConfig.bacteriaMutationResistanceCap)).append((Component)arrow).append((Component)ComponentUtils.colored("[", ChatFormatting.GREEN)).append((Component)ComponentUtils.statRange(MathUtils.roundToPrecision(this.mutationResistance + 0.05f * (1.0f - this.mutationResistance / NTConfig.bacteriaMutationResistanceCap), 2), MathUtils.roundToPrecision(this.mutationResistance + 0.1f, 2), Float.valueOf(NTConfig.bacteriaMutationResistanceCap))).append((Component)ComponentUtils.colored("]", ChatFormatting.GREEN)), ComponentUtils.countableStatShow("Production Rate", Float.valueOf(this.productionRate), Float.valueOf(NTConfig.bacteriaProductionRateCap)).append((Component)arrow).append((Component)ComponentUtils.colored("[", ChatFormatting.GREEN)).append((Component)ComponentUtils.statRange(MathUtils.roundToPrecision(this.productionRate + -this.productionRate / (10.0f * (1.0f + this.mutationResistance)), 2), MathUtils.roundToPrecision(this.productionRate + this.productionRate / (10.0f * (1.0f + this.mutationResistance)), 2), Float.valueOf(NTConfig.bacteriaProductionRateCap))).append((Component)ComponentUtils.colored("]", ChatFormatting.GREEN)), ComponentUtils.countableStatShow("Lifespan", this.lifespan, NTConfig.bacteriaLifespanCap).append((Component)arrow).append((Component)ComponentUtils.colored("[", ChatFormatting.GREEN)).append((Component)ComponentUtils.statRange(this.lifespan + (int)(-100.0f / (1.0f + this.mutationResistance)), this.lifespan + (int)(100.0f / (1.0f + this.mutationResistance)), NTConfig.bacteriaLifespanCap)).append((Component)ComponentUtils.colored("]", ChatFormatting.GREEN)));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SimpleCollapsedStats.class, "baseStats;growthRate;mutationResistance;productionRate;lifespan;color", "baseStats", "growthRate", "mutationResistance", "productionRate", "lifespan", "color"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SimpleCollapsedStats.class, "baseStats;growthRate;mutationResistance;productionRate;lifespan;color", "baseStats", "growthRate", "mutationResistance", "productionRate", "lifespan", "color"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SimpleCollapsedStats.class, "baseStats;growthRate;mutationResistance;productionRate;lifespan;color", "baseStats", "growthRate", "mutationResistance", "productionRate", "lifespan", "color"}, this, o);
    }

    public SimpleBacteriaStats baseStats() {
        return this.baseStats;
    }

    @Override
    public float growthRate() {
        return this.growthRate;
    }

    @Override
    public float mutationResistance() {
        return this.mutationResistance;
    }

    @Override
    public float productionRate() {
        return this.productionRate;
    }

    @Override
    public int lifespan() {
        return this.lifespan;
    }

    @Override
    public int color() {
        return this.color;
    }
}

