/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities;

import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public class BreakerBlockEntity
extends LaserBlockEntity {
    private boolean running;
    private int counter;

    public BreakerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(null, blockPos, blockState);
    }

    @Override
    public Set<Direction> getLaserInputs() {
        return ObjectSet.of((Object[])new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH});
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        return ObjectSet.of();
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    @Override
    public void commonTick() {
        super.commonTick();
        if (this.level instanceof ServerLevel && this.getPower() >= 1) {
            if (this.running) {
                if (this.counter >= 20) {
                    this.counter = 0;
                    this.running = false;
                    this.spawnLoot();
                }
                ++this.counter;
            } else {
                this.running = true;
            }
        }
    }

    private void spawnLoot() {
        BlockState block = this.level.getBlockState(this.worldPosition.below());
        List stacks = block.getDrops(new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.worldPosition)).withParameter(LootContextParams.TOOL, (Object)Items.DIAMOND_PICKAXE.getDefaultInstance()));
        if (!stacks.isEmpty()) {
            this.level.removeBlock(this.worldPosition.below(), false);
            for (ItemStack stack : stacks) {
                Vec3 pos = this.getItemSpawnPos();
                ItemEntity itemEntity = new ItemEntity(this.level, pos.x, pos.y, pos.z, stack);
                this.level.addFreshEntity((Entity)itemEntity);
            }
        }
    }

    private Vec3 getItemSpawnPos() {
        return new Vec3((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.5, (double)this.worldPosition.getZ() + 0.5);
    }
}

