/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities;

import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.api.bacteria.BacteriaInstance;
import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.content.menus.IncubatorMenu;
import com.portingdeadmods.nautec.content.recipes.BacteriaIncubationRecipe;
import com.portingdeadmods.nautec.content.recipes.inputs.BacteriaRecipeInput;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.utils.RNGUtils;
import com.portingdeadmods.nautec.utils.ranges.IntRange;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public class IncubatorBlockEntity
extends LaserBlockEntity
implements MenuProvider {
    public static final int MAX_PROGRESS = 100;
    public static final int POWER_USAGE = 20;
    private BacteriaIncubationRecipe recipe;
    private int progress;

    public IncubatorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.INCUBATOR.get(), blockPos, blockState);
        this.addItemHandler(1, 1);
        this.addBacteriaStorage(1);
    }

    @Override
    protected void onItemsChanged(int slot) {
        super.onItemsChanged(slot);
        this.checkRecipe();
    }

    @Override
    public void onBacteriaChanged(int slot) {
        super.onBacteriaChanged(slot);
        this.checkRecipe();
    }

    private void checkRecipe() {
        ItemStack stack = this.getItemHandler().getStackInSlot(0);
        BacteriaInstance instance = this.getBacteriaStorage().getBacteria(0);
        this.recipe = instance.getSize() < NTConfig.bacteriaColonySizeCap ? (BacteriaIncubationRecipe)this.level.getRecipeManager().getRecipeFor(BacteriaIncubationRecipe.TYPE, (RecipeInput)new BacteriaRecipeInput(instance, stack), this.level).map(RecipeHolder::value).orElse(null) : null;
    }

    @Override
    public void commonTick() {
        super.commonTick();
        if (this.recipe != null) {
            if (this.getPower() >= 20) {
                if (this.progress >= 100) {
                    IntRange growth = this.recipe.growth();
                    if (this.level.getRandom().nextFloat() < this.recipe.consumeChance()) {
                        this.getItemHandler().extractItem(0, 1, false);
                    }
                    BacteriaInstance bacteria = this.getBacteriaStorage().getBacteria(0);
                    bacteria.grow(RNGUtils.uniformRandInt(growth));
                    this.getBacteriaStorage().onBacteriaChanged(0);
                    this.progress = 0;
                } else {
                    ++this.progress;
                }
            }
        } else {
            this.progress = 0;
        }
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    public Set<Direction> getLaserInputs() {
        return ObjectSet.of((Object)Direction.UP, (Object)Direction.DOWN);
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        return ObjectSet.of();
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    public Component getDisplayName() {
        return Component.literal((String)"Incubator");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new IncubatorMenu(containerId, playerInventory, this);
    }

    @Override
    protected void loadData(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadData(tag, provider);
        this.progress = tag.getInt("progress");
    }

    @Override
    protected void saveData(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveData(tag, provider);
        tag.putInt("progress", this.progress);
    }
}

