/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blockentities.multiblock.semi;

import com.portingdeadmods.nautec.api.blockentities.LaserBlockEntity;
import com.portingdeadmods.nautec.capabilities.IOActions;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public class PrismarineCrystalBlockEntity
extends LaserBlockEntity {
    private boolean breaking;
    private long startTick;
    private int duration;

    public PrismarineCrystalBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(NTBlockEntityTypes.PRISMARINE_CRYSTAL.get(), blockPos, blockState);
    }

    @Override
    public Set<Direction> getLaserInputs() {
        return ObjectSet.of((Object[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
    }

    @Override
    public Set<Direction> getLaserOutputs() {
        return ObjectSet.of();
    }

    @Override
    public <T> Map<Direction, Pair<IOActions, int[]>> getSidedInteractions(BlockCapability<T, @Nullable Direction> capability) {
        return Map.of();
    }

    @Override
    public void commonTick() {
        super.commonTick();
        this.setPurity(3.0f);
        if (this.duration > 0 && this.isBreaking()) {
            --this.duration;
            if (this.duration == 0) {
                this.breaking = false;
            }
        }
    }

    public boolean isBreaking() {
        return this.breaking;
    }

    public long getStartTick() {
        return this.startTick;
    }

    public int getDuration() {
        return this.duration;
    }

    public void playBreakAnimation() {
        this.breaking = true;
        this.startTick = this.level.getGameTime();
        this.duration = 10;
    }
}

