/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blocks;

import com.portingdeadmods.nautec.content.blockentities.BacterialAnalyzerBlockEntity;
import com.portingdeadmods.nautec.registries.NTBlocks;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BacterialAnalyzerTopBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape SHAPE_N = Stream.of(Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)12.0), Block.box((double)7.0, (double)2.0, (double)10.0, (double)9.0, (double)12.0, (double)12.0), Block.box((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)5.0, (double)9.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0)).reduce(Shapes::or).get();
    public static final VoxelShape SHAPE_E = Stream.of(Block.box((double)4.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.box((double)4.0, (double)2.0, (double)7.0, (double)6.0, (double)12.0, (double)9.0), Block.box((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)5.0, (double)9.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), Block.box((double)7.0, (double)5.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0)).reduce(Shapes::or).get();
    public static final VoxelShape SHAPE_S = Stream.of(Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)2.0, (double)11.0), Block.box((double)7.0, (double)2.0, (double)4.0, (double)9.0, (double)12.0, (double)6.0), Block.box((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)5.0, (double)9.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), Block.box((double)7.0, (double)5.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0)).reduce(Shapes::or).get();
    public static final VoxelShape SHAPE_W = Stream.of(Block.box((double)5.0, (double)0.0, (double)5.0, (double)12.0, (double)2.0, (double)11.0), Block.box((double)10.0, (double)2.0, (double)7.0, (double)12.0, (double)12.0, (double)9.0), Block.box((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)5.0, (double)9.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), Block.box((double)7.0, (double)5.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0)).reduce(Shapes::or).get();

    public BacterialAnalyzerTopBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockPos below = pos.below();
        BlockEntity blockEntity = level.getBlockEntity(below);
        if (blockEntity instanceof BacterialAnalyzerBlockEntity) {
            BacterialAnalyzerBlockEntity be = (BacterialAnalyzerBlockEntity)blockEntity;
            player.openMenu((MenuProvider)be, below);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return NTBlocks.BACTERIAL_ANALYZER.toStack();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> SHAPE_N;
            case Direction.EAST -> SHAPE_E;
            case Direction.SOUTH -> SHAPE_S;
            case Direction.WEST -> SHAPE_W;
            default -> super.getShape(state, level, pos, context);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING}));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (!state.is(newState.getBlock())) {
            level.removeBlock(pos.below(), false);
        }
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }
}

