/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blocks;

import com.mojang.serialization.MapCodec;
import com.portingdeadmods.nautec.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.nautec.api.blocks.blockentities.LaserBlock;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LaserJunctionBlock
extends LaserBlock {
    public static final EnumProperty<ConnectionType>[] CONNECTION = new EnumProperty[6];
    public final int border;
    public final VoxelShape shapeCenter;
    public final VoxelShape shapeD;
    public final VoxelShape shapeU;
    public final VoxelShape shapeN;
    public final VoxelShape shapeS;
    public final VoxelShape shapeW;
    public final VoxelShape shapeE;
    public final VoxelShape[] shapes;

    public LaserJunctionBlock(BlockBehaviour.Properties properties, int width) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(CONNECTION[0], (Comparable)((Object)ConnectionType.NONE))).setValue(CONNECTION[1], (Comparable)((Object)ConnectionType.NONE))).setValue(CONNECTION[2], (Comparable)((Object)ConnectionType.NONE))).setValue(CONNECTION[3], (Comparable)((Object)ConnectionType.NONE))).setValue(CONNECTION[4], (Comparable)((Object)ConnectionType.NONE))).setValue(CONNECTION[5], (Comparable)((Object)ConnectionType.NONE)));
        int B0 = this.border = (16 - width) / 2;
        int B1 = 16 - this.border;
        this.shapeCenter = LaserJunctionBlock.box((double)B0, (double)B0, (double)B0, (double)B1, (double)B1, (double)B1);
        this.shapeD = LaserJunctionBlock.box((double)B0, (double)0.0, (double)B0, (double)B1, (double)B0, (double)B1);
        this.shapeU = LaserJunctionBlock.box((double)B0, (double)B1, (double)B0, (double)B1, (double)16.0, (double)B1);
        this.shapeN = LaserJunctionBlock.box((double)B0, (double)B0, (double)0.0, (double)B1, (double)B1, (double)B0);
        this.shapeS = LaserJunctionBlock.box((double)B0, (double)B0, (double)B1, (double)B1, (double)B1, (double)16.0);
        this.shapeW = LaserJunctionBlock.box((double)0.0, (double)B0, (double)B0, (double)B0, (double)B1, (double)B1);
        this.shapeE = LaserJunctionBlock.box((double)B1, (double)B0, (double)B0, (double)16.0, (double)B1, (double)B1);
        this.shapes = new VoxelShape[64];
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        int index = 0;
        for (Direction direction : Direction.values()) {
            if (blockState.getValue(CONNECTION[direction.ordinal()]) == ConnectionType.NONE) continue;
            index |= 1 << direction.ordinal();
        }
        return this.getShape(index);
    }

    @Override
    public boolean waterloggable() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{CONNECTION[0], CONNECTION[1], CONNECTION[2], CONNECTION[3], CONNECTION[4], CONNECTION[5]}));
    }

    public VoxelShape getShape(int i) {
        if (this.shapes[i] == null) {
            this.shapes[i] = this.shapeCenter;
            if ((i & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeD);
            }
            if ((i >> 1 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeU);
            }
            if ((i >> 2 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeN);
            }
            if ((i >> 3 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeS);
            }
            if ((i >> 4 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeW);
            }
            if ((i >> 5 & 1) != 0) {
                this.shapes[i] = Shapes.or((VoxelShape)this.shapes[i], (VoxelShape)this.shapeE);
            }
        }
        return this.shapes[i];
    }

    @Override
    public BlockEntityType<? extends ContainerBlockEntity> getBlockEntityType() {
        return NTBlockEntityTypes.LASER_JUNCTION.get();
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return LaserJunctionBlock.simpleCodec(props -> new LaserJunctionBlock((BlockBehaviour.Properties)props, 8));
    }

    static {
        for (Direction dir : Direction.values()) {
            LaserJunctionBlock.CONNECTION[dir.get3DDataValue()] = EnumProperty.create((String)dir.getSerializedName(), ConnectionType.class);
        }
    }

    public static enum ConnectionType implements StringRepresentable
    {
        INPUT("input"),
        OUTPUT("output"),
        NONE("none");

        private final String name;

        private ConnectionType(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

