/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.blocks.multiblock.controller;

import com.mojang.serialization.MapCodec;
import com.portingdeadmods.nautec.api.blockentities.ContainerBlockEntity;
import com.portingdeadmods.nautec.api.blocks.blockentities.ContainerBlock;
import com.portingdeadmods.nautec.api.multiblocks.Multiblock;
import com.portingdeadmods.nautec.content.blockentities.multiblock.controller.DrainBlockEntity;
import com.portingdeadmods.nautec.content.blocks.multiblock.part.DrainPartBlock;
import com.portingdeadmods.nautec.content.multiblocks.DrainMultiblock;
import com.portingdeadmods.nautec.registries.NTBlockEntityTypes;
import com.portingdeadmods.nautec.registries.NTMultiblocks;
import com.portingdeadmods.nautec.utils.ItemUtils;
import com.portingdeadmods.nautec.utils.MultiblockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.enums.BubbleColumnDirection;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class DrainBlock
extends ContainerBlock {
    public DrainBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DrainMultiblock.FORMED, (Comparable)Boolean.valueOf(false))).setValue((Property)DrainPartBlock.OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)DrainPartBlock.HAS_POWER, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{DrainMultiblock.DRAIN_PART, Multiblock.FORMED, DrainPartBlock.OPEN, DrainPartBlock.HAS_POWER}));
    }

    @Override
    public boolean tickingEnabled() {
        return true;
    }

    @Override
    public BlockEntityType<? extends ContainerBlockEntity> getBlockEntityType() {
        return NTBlockEntityTypes.DRAIN.get();
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return DrainBlock.simpleCodec(DrainBlock::new);
    }

    @Override
    @NotNull
    protected InteractionResult useWithoutItem(BlockState p_60503_, Level level, BlockPos pos, Player player, BlockHitResult p_60508_) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DrainBlockEntity) {
            ItemStack stack;
            IFluidHandler itemFluidHandler;
            DrainBlockEntity drainBlockEntity = (DrainBlockEntity)blockEntity;
            if (player.isShiftKeyDown() && !drainBlockEntity.isMoving()) {
                if (((Boolean)p_60503_.getValue((Property)DrainPartBlock.OPEN)).booleanValue()) {
                    drainBlockEntity.close();
                } else {
                    drainBlockEntity.open();
                }
                return InteractionResult.SUCCESS;
            }
            if (((Boolean)p_60503_.getValue((Property)Multiblock.FORMED)).booleanValue() && (itemFluidHandler = (IFluidHandler)(stack = player.getMainHandItem()).getCapability(Capabilities.FluidHandler.ITEM)) != null) {
                DrainBlock.extractFluid(player, level, InteractionHand.MAIN_HAND, (FluidTank)drainBlockEntity.getFluidHandler(), itemFluidHandler);
                return InteractionResult.SUCCESS;
            }
        }
        return super.useWithoutItem(p_60503_, level, pos, player, p_60508_);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (((Boolean)state.getValue((Property)DrainPartBlock.OPEN)).booleanValue() && ((Boolean)state.getValue((Property)DrainPartBlock.HAS_POWER)).booleanValue()) {
            entity.hurt(level.damageSources().drown(), 4.0f);
        }
    }

    public BubbleColumnDirection getBubbleColumnDirection(BlockState state) {
        if (((Boolean)state.getValue((Property)DrainPartBlock.OPEN)).booleanValue() && ((Boolean)state.getValue((Property)DrainPartBlock.HAS_POWER)).booleanValue()) {
            return BubbleColumnDirection.DOWNWARD;
        }
        return super.getBubbleColumnDirection(state);
    }

    private static void extractFluid(Player player, Level level, InteractionHand interactionHand, FluidTank fluidHandler, IFluidHandler fluidHandlerItem) {
        FluidStack fluidInTank = fluidHandler.getFluidInTank(0);
        if (player.getItemInHand(interactionHand).is(Items.BUCKET)) {
            player.getItemInHand(interactionHand).shrink(1);
            ItemUtils.giveItemToPlayerNoSound(player, fluidInTank.getFluid().getBucket().getDefaultInstance());
            if (fluidInTank.is((Fluid)Fluids.WATER)) {
                level.playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), SoundEvents.BUCKET_FILL, SoundSource.PLAYERS, 0.8f, 1.0f);
            } else if (fluidInTank.is((Fluid)Fluids.LAVA)) {
                level.playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), SoundEvents.BUCKET_FILL_LAVA, SoundSource.PLAYERS, 0.8f, 1.0f);
            }
            fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        } else {
            FluidStack fluidStack = fluidHandler.drain(fluidHandler.getFluidInTank(0).getAmount(), IFluidHandler.FluidAction.EXECUTE);
            int remainderAmount = fluidHandlerItem.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            FluidStack newFluidStack = fluidStack.copy();
            newFluidStack.setAmount(remainderAmount);
            fluidHandler.setFluid(newFluidStack);
        }
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            MultiblockHelper.unform(NTMultiblocks.DRAIN.get(), pos, level, null);
            level.removeBlock(pos.above(), false);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }
}

