/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.content.commands.arguments.AugmentSlotArgumentType;
import com.portingdeadmods.nautec.utils.AugmentHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class RemoveAugmentCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder nautecCommand = (LiteralArgumentBuilder)Commands.literal((String)"nautec").requires(player -> player.hasPermission(2));
        dispatcher.register((LiteralArgumentBuilder)nautecCommand.then(Commands.literal((String)"augments").then(Commands.literal((String)"remove").then(Commands.argument((String)"slot", (ArgumentType)AugmentSlotArgumentType.getInstance()).executes(RemoveAugmentCommand::execute)))));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        AugmentSlot slot = (AugmentSlot)ctx.getArgument("slot", AugmentSlot.class);
        Augment currentAugment = AugmentHelper.getAugmentBySlot((Player)player, slot);
        if (currentAugment == null) {
            player.sendSystemMessage((Component)Component.literal((String)("No augment found in slot: " + slot.getName())));
            return 0;
        }
        AugmentHelper.removeAugment((Player)player, slot);
        player.sendSystemMessage((Component)Component.literal((String)("Removed augment from slot: " + slot.getName())));
        return 1;
    }
}

