/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.entites;

import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownBouncingTrident
extends ThrownTrident {
    int bouncesLeft = 1;

    public ThrownBouncingTrident(EntityType<? extends ThrownTrident> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownBouncingTrident(Level world, LivingEntity owner, ItemStack stack, int bouncesLeft) {
        super(world, owner, stack);
        this.bouncesLeft = bouncesLeft;
    }

    public ThrownBouncingTrident createBouncingTrident(Level level, LivingEntity thrower, int bouncesLeft) {
        if (thrower == null) {
            return null;
        }
        ThrownBouncingTrident trident = new ThrownBouncingTrident(level, thrower, ItemStack.EMPTY, bouncesLeft);
        return trident;
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
        if (result instanceof BlockHitResult && this.bouncesLeft > 0) {
            --this.bouncesLeft;
            this.bounce((BlockHitResult)result);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    private void bounce(BlockHitResult result) {
        Direction face = result.getDirection();
        Vec3 normal = new Vec3((double)face.getNormal().getX(), (double)face.getNormal().getY(), (double)face.getNormal().getZ());
        Vec3 motion = this.getDeltaMovement();
        double dot = motion.dot(normal) * 2.0;
        Vec3 reflect = motion.subtract(normal.scale(dot));
        double verticalBoost = 0.3;
        reflect = reflect.add(0.0, verticalBoost, 0.0);
        double forwardDamping = 0.5;
        reflect = reflect.multiply(new Vec3(forwardDamping, 1.0, forwardDamping));
        ThrownBouncingTrident trident = this.createBouncingTrident(this.level(), (LivingEntity)this.getOwner(), this.bouncesLeft);
        if (trident == null) {
            return;
        }
        trident.setPos(result.getLocation().x() + reflect.x() / 5.0, result.getLocation().y() + reflect.y() / 5.0, result.getLocation().z() + reflect.z() / 5.0);
        trident.setDeltaMovement(reflect);
        double speed = reflect.length();
        trident.setXRot((float)Math.toDegrees(Mth.atan2((double)reflect.y, (double)speed)));
        trident.setYRot((float)Math.toDegrees(Mth.atan2((double)reflect.x, (double)reflect.z)));
        trident.reapplyPosition();
        trident.pickup = AbstractArrow.Pickup.DISALLOWED;
        trident.noPhysics = this.noPhysics;
        this.level().addFreshEntity((Entity)trident);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        this.bouncesLeft = 0;
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    public void tickDespawn() {
        if (this.tickCount > 200) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }
}

