/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.content.items.tiers;

import com.portingdeadmods.nautec.registries.NTItems;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class NTArmorMaterials {
    public static final Holder<ArmorMaterial> PRISMARINE = NTArmorMaterials.register("prismarine", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 0);
        map.put(ArmorItem.Type.LEGGINGS, 0);
        map.put(ArmorItem.Type.CHESTPLATE, 0);
        map.put(ArmorItem.Type.HELMET, 2);
        map.put(ArmorItem.Type.BODY, 2);
    }), 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_ELYTRA, 0.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE}));
    public static final Holder<ArmorMaterial> DIVING_SUIT = NTArmorMaterials.register("diving_suit", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 2);
        map.put(ArmorItem.Type.LEGGINGS, 4);
        map.put(ArmorItem.Type.CHESTPLATE, 5);
        map.put(ArmorItem.Type.HELMET, 3);
        map.put(ArmorItem.Type.BODY, 4);
    }), 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.0f, 0.05f, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_INGOT}));
    public static final Holder<ArmorMaterial> AQUARINE_STEEL = NTArmorMaterials.register("aquarine_steel", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 3);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.CHESTPLATE, 7);
        map.put(ArmorItem.Type.HELMET, 3);
        map.put(ArmorItem.Type.BODY, 4);
    }), 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, 1.0f, 0.05f, () -> Ingredient.of((ItemLike[])new ItemLike[]{NTItems.AQUARINE_STEEL_INGOT}));

    private static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(ResourceLocation.withDefaultNamespace((String)name)));
        return NTArmorMaterials.register(name, defense, enchantmentValue, equipSound, toughness, knockbackResistance, repairIngredient, list);
    }

    private static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngridient, List<ArmorMaterial.Layer> layers) {
        EnumMap<ArmorItem.Type, Integer> enummap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type armoritem$type : ArmorItem.Type.values()) {
            enummap.put(armoritem$type, defense.get(armoritem$type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)name), (Object)new ArmorMaterial(enummap, enchantmentValue, equipSound, repairIngridient, layers, toughness, knockbackResistance));
    }
}

