/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.data;

import com.portingdeadmods.nautec.data.NTDataComponents;
import com.portingdeadmods.nautec.data.components.ComponentBacteriaStorage;
import com.portingdeadmods.nautec.registries.NTBacterias;
import net.minecraft.world.item.ItemStack;

public final class NTDataComponentsUtils {
    public static void setOxygenLevels(ItemStack stack, Integer value) {
        stack.set(NTDataComponents.OXYGEN, (Object)value);
    }

    public static Integer getOxygenLevels(ItemStack stack) {
        return (Integer)stack.getOrDefault(NTDataComponents.OXYGEN, (Object)0);
    }

    public static void setAbilityStatus(ItemStack stack, Boolean value) {
        stack.set(NTDataComponents.ABILITY_ENABLED, (Object)value);
    }

    public static Boolean isAbilityEnabled(ItemStack stack) {
        return (Boolean)stack.getOrDefault(NTDataComponents.ABILITY_ENABLED, (Object)false);
    }

    public static float isAbilityEnabledNBT(ItemStack stack) {
        return (Boolean)stack.getOrDefault(NTDataComponents.ABILITY_ENABLED, (Object)false) != false ? 1.0f : 0.0f;
    }

    public static float hasBacteria(ItemStack stack) {
        return ((ComponentBacteriaStorage)stack.get(NTDataComponents.BACTERIA)).bacteriaInstance().getBacteria() != NTBacterias.EMPTY ? 1.0f : 0.0f;
    }

    public static void setInfusedStatus(ItemStack stack, Boolean value) {
        stack.set(NTDataComponents.IS_INFUSED, (Object)value);
    }

    public static Boolean isInfused(ItemStack stack) {
        return (Boolean)stack.getOrDefault(NTDataComponents.IS_INFUSED, (Object)false);
    }
}

