/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen;

import com.klikli_dev.modonomicon.api.datagen.AbstractModonomiconLanguageProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.registries.NTBacterias;
import com.portingdeadmods.nautec.registries.NTBlocks;
import com.portingdeadmods.nautec.registries.NTFluids;
import com.portingdeadmods.nautec.registries.NTItems;
import com.portingdeadmods.nautec.utils.Utils;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class EnUsProvider
extends AbstractModonomiconLanguageProvider {
    public EnUsProvider(PackOutput output, ModonomiconLanguageProvider cacheProvider) {
        super(output, "nautec", "en_us", cacheProvider);
    }

    protected void addTranslations() {
        this.curiosIdent("prism_monocle", "Monocle");
        this.curiosIdent("battery", "Battery");
        this.add("nautec.creative_tab.main", "NauTec");
        this.add("nautec.creative_tab.bacteria", "NauTec Bacteria");
        this.addFluidType(NTFluids.SALT_WATER.getFluidType(), "Salt Water");
        this.addFluidType(NTFluids.EAS.getFluidType(), "Electrolyte Algae Serum");
        this.addFluidType(NTFluids.ETCHING_ACID.getFluidType(), "Etching Acid");
        this.addFluidType(NTFluids.OIL.getFluidType(), "Oil");
        this.addItem((Supplier)NTItems.PRISM_MONOCLE, "Prism Monocle");
        this.addItem((Supplier)NTItems.AQUARINE_STEEL_INGOT, "Aquarine Steel Ingot");
        this.addItem((Supplier)NTItems.ATLANTIC_GOLD_INGOT, "Atlantic Gold Ingot");
        this.addItem((Supplier)NTItems.ATLANTIC_GOLD_NUGGET, "Atlantic Gold Nugget");
        this.addItem((Supplier)NTFluids.SALT_WATER.getDeferredBucket(), "Salt Water Bucket");
        this.addItem((Supplier)NTFluids.EAS.getDeferredBucket(), "Electrolyte Algae Serum (EAS) Bucket");
        this.addItem((Supplier)NTFluids.OIL.getDeferredBucket(), "Oil Bucket");
        this.addItem((Supplier)NTItems.GLASS_VIAL, "Glass Vial");
        this.addItem((Supplier)NTItems.ELECTROLYTE_ALGAE_SERUM_VIAL, "Electrolyte Algae Serum (EAS) Vial");
        this.addItem((Supplier)NTItems.CROWBAR, "Crowbar");
        this.addItem((Supplier)NTItems.RUSTY_GEAR, "Rusty Gear");
        this.addItem((Supplier)NTItems.GEAR, "Gear");
        this.addItem((Supplier)NTItems.ANCIENT_VALVE, "Ancient Valve");
        this.addItem((Supplier)NTItems.PETRI_DISH, "Petri Dish");
        this.addItem("drowned_lungs", "Drowned Lungs");
        this.addItem("diving_helmet", "Diving Helmet");
        this.addItem("diving_chestplate", "Diving Chestplate");
        this.addItem("diving_leggings", "Diving Leggings");
        this.addItem("diving_boots", "Diving Boots");
        this.addItem("aquarine_steel_wrench", "Aquarine Steel Wrench");
        this.addItem("etching_acid_bucket", "Etching Acid Bucket");
        this.addItem("aquarine_steel_sword", "Aquarine Steel Sword");
        this.addItem("aquarine_steel_pickaxe", "Aquarine Steel Pickaxe");
        this.addItem("aquarine_steel_axe", "Aquarine Steel Axe");
        this.addItem("aquarine_steel_shovel", "Aquarine Steel Shovel");
        this.addItem("aquarine_steel_hoe", "Aquarine Steel Hoe");
        this.addItem("neptunes_trident", "Neptune's Trident");
        this.addItem("aquarine_steel_helmet", "Aquarine Steel Helmet");
        this.addItem("aquarine_steel_chestplate", "Aquarine Steel Chestplate");
        this.addItem("aquarine_steel_leggings", "Aquarine Steel Leggings");
        this.addItem("aquarine_steel_boots", "Aquarine Steel Boots");
        this.addItem("dolphin_fin", "Dolphin Fin");
        this.addItem("broken_whisk", "Broken Whisk");
        this.addItem("whisk", "Whisk");
        this.addItem("prismatic_battery", "Prismatic Battery");
        this.addItem("air_bottle", "Pressurized Air Bottle");
        this.addItem("aquarine_steel_compound", "Aquarine Steel Compound");
        this.addItem("prismarine_crystal_shard", "Prismarine Crystal Shard");
        this.addItem("claw_robot_arm", "Claw Robot Arm");
        this.addItem("syringe_robot_arm", "Syringe Robot Arm");
        this.addItem("deepslate_rod", "Deepslate Rod");
        this.addItem("brown_polymer", "Brown Polymer");
        this.addItem("cast_iron_ingot", "Cast Iron Ingot");
        this.addItem("cast_iron_rod", "Cast Iron Rod");
        this.addItem("cast_iron_nugget", "Cast Iron Nugget");
        this.addItem("salt", "Salt");
        this.addItem("damaged_aquatic_chip", "Damaged Aquatic Chip");
        this.addItem((Supplier)NTItems.LASER_CHANNELING_COIL, "Laser Channeling Coil");
        this.addItem((Supplier)NTItems.BURNT_COIL, "Burnt Coil");
        this.addItem((Supplier)NTItems.ELDRITCH_HEART, "Eldritch Heart");
        this.addItem((Supplier)NTItems.GUARDIAN_EYE, "Guardian Eye");
        this.addItem((Supplier)NTItems.VALVE, "Valve");
        this.addItem((Supplier)NTItems.CAST_IRON_COMPOUND, "Cast Iron Compound");
        this.addItem((Supplier)NTItems.GRAFTING_TOOL, "Grafting Tool");
        this.addItem((Supplier)NTItems.PRISMARINE_LENS, "Prismarine Lens");
        this.addItem((Supplier)NTItems.AQUATIC_CHIP, "Aquatic Chip");
        this.add("nautec_guide.desc.0", "Nautec's Guide");
        this.addBlock("rusty_crate", "Rusty Crate");
        this.addBlock("polished_prismarine", "Polished Prismarine");
        this.addBlock("mixer", "Mixer");
        this.addBlock("long_distance_laser", "Long Distance Laser");
        this.addBlock("laser_junction", "Laser Junction");
        this.addBlock("prismarine_crystal", "Prismarine Crystal");
        this.addBlock("decorative_prismarine_crystal", "Decorative Prismarine Crystal");
        this.addBlock("decorative_prismarine_crystal_part", "Decorative Prismarine Crystal");
        this.addBlock("deep_sea_drain_wall", "Deep Sea Drain Wall");
        this.addBlock("augmentation_station", "Augmentation Station");
        this.addBlock("aquarine_steel_block", "Aquarine Steel Block");
        this.addBlock("aquatic_catalyst", "Aquatic Catalyst");
        this.addBlock("dark_prismarine_pillar", "Dark Prismarine Pillar");
        this.addBlock("chiseled_dark_prismarine", "Chiseled Dark Prismarine");
        this.addBlock("crate", "Crate");
        this.addBlock("prismarine_laser_relay", "Prismarine Laser Relay");
        this.addBlock("deep_sea_drain", "Deep Sea Drain");
        this.addBlock("augmentation_station_part", "Augmentation Station");
        this.addBlock("prismarine_crystal_part", "Prismarine Crystal");
        this.addBlock("anchor", "Anchor");
        this.addBlock("oil_barrel", "Oil Barrel");
        this.addBlock((Supplier)NTBlocks.AUGMENTATION_STATION_EXTENSION, "Augmentation Station Extension");
        this.addBlock((Supplier)NTBlocks.CHARGER, "Charger");
        this.addBlock((Supplier)NTBlocks.PRISMARINE_SAND, "Prismarine Sand");
        this.addBlock((Supplier)NTBlocks.CREATIVE_POWER_SOURCE, "Creative Power Source");
        this.addBlock((Supplier)NTBlocks.MUTATOR, "Mutator");
        this.addBlock((Supplier)NTBlocks.INCUBATOR, "Incubator");
        this.addBlock((Supplier)NTBlocks.BIO_REACTOR, "Bio Reactor");
        this.addBlock((Supplier)NTBlocks.BACTERIAL_ANALYZER, "Bacterial Analyzer");
        this.addBlock((Supplier)NTBlocks.FISHING_STATION, "Fishing Station");
        this.addBlock((Supplier)NTBlocks.BACTERIAL_CONTAINMENT_SHIELD, "Bacteria Containment Shield");
        this.addBlock((Supplier)NTBlocks.CAST_IRON_BLOCK, "Cast Iron Block");
        this.add("multiblock.info.failed_to_construct", "Missing or invalid block");
        this.add("multiblock.info.actual_block", "Block: %s");
        this.add("multiblock.info.expected_block", "Expected: %s");
        this.add("multiblock.info.block_pos", "Coordinates: %d, %d, %d");
        this.add("augment_slot.nautec.head", "Head");
        this.add("augment_slot.nautec.eyes", "Eyes");
        this.add("augment_slot.nautec.body", "Body");
        this.add("augment_slot.nautec.lung", "Lungs");
        this.add("augment_slot.nautec.left_leg", "Left Leg");
        this.add("augment_slot.nautec.right_leg", "Right Leg");
        this.add("augment_slot.nautec.left_arm", "Left Arm");
        this.add("augment_slot.nautec.right_arm", "Right Arm");
        this.add("augment_slot.nautec.heart", "Heart");
        this.add("augment_type.nautec.drowned_lung", "Drowned Lung");
        this.add("augment_type.nautec.guardian_eye", "Guardian Eye");
        this.add("augment_type.nautec.dolphin_fin", "Dolphin Fin");
        this.add("nautec.air_bottle.fill", "Right click a glass bottle on a bubble column to fill with pressurized air");
        this.add("nautec.air_bottle.craft_msg", "Either Craft with Chestplate or drink while wearing chestplate to increase oxygen level");
        this.add("nautec.edible", "Edible");
        this.add("nautec.armor.ability.desc", "Ability: Increases protection when powered");
        this.add("nautec.armor.power", "Power: ");
        this.add("nautec.armor.status", "Status: ");
        this.add("nautec.armor.enabled", "Enabled");
        this.add("nautec.armor.disabled", "Shift + Right Click to Enable");
        this.add("nautec.helm.desc", "Allows you to see better underwater.");
        this.add("nautec.tool.axe.ability", "Ability: Chop Down Entire Trees");
        this.add("nautec.tool.hoe.ability", "Ability: Till 3x3 Farmland");
        this.add("nautec.tool.pickaxe.ability", "Ability: Mine in a 3x3 Area");
        this.add("nautec.tool.shovel.ability", "Ability: Mine in a 3x3 Area");
        this.add("nautec.tool.sword.ability", "Ability: Deal 70% more damage and spawn lightnings at targets");
        this.add("nautec.tool.infuse-me", "Infuse in Algae Serum to unlock Abilities");
        this.add("nautec.tool.status", "Status: ");
        this.add("nautec.tool.power", "Power: ");
        this.add("nautec.tool.enabled", "Enabled");
        this.add("nautec.tool.disabled", "Shift + Right Click to Enable");
        this.add("block.nautec.brown_polymer_block", "Brown Polymer Block");
        for (ResourceKey<Bacteria> key : NTBacterias.BACTERIAS) {
            this.addDirectBacteria(key);
        }
    }

    private void addFluidType(Supplier<? extends FluidType> fluidType, String val) {
        this.add(Utils.registryTranslation(NeoForgeRegistries.FLUID_TYPES, fluidType.get()).getString(), val);
    }

    private void curiosIdent(String key, String val) {
        this.add("curios.identifier." + key, val);
    }

    private void addItem(String key, String val) {
        this.add("item.nautec." + key, val);
    }

    private void addBacteria(ResourceKey<?> key, String val) {
        this.add(key.registry().getPath() + "." + key.location().getNamespace() + "." + key.location().getPath(), val);
    }

    private void addDirectBacteria(ResourceKey<?> key) {
        String[] name = key.location().getPath().split("_");
        String val = Arrays.stream(name).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).reduce((s1, s2) -> s1 + " " + s2).orElse("");
        this.add(key.registry().getPath() + "." + key.location().getNamespace() + "." + key.location().getPath(), val);
    }

    private void addBlock(String key, String val) {
        this.add("block.nautec." + key, val);
    }
}

