/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.datagen.recipeBuilder;

import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.content.recipes.BacteriaIncubationRecipe;
import com.portingdeadmods.nautec.datagen.recipeBuilder.NTRecipeBuilder;
import com.portingdeadmods.nautec.utils.ranges.IntRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public record IncubationRecipeBuilder(ResourceKey<Bacteria> bacteria, Ingredient nutrient, IntRange growth, float consumeChance) implements NTRecipeBuilder
{
    public RecipeBuilder unlockedBy(String s, Criterion<?> criterion) {
        return this;
    }

    public RecipeBuilder group(@Nullable String s) {
        return this;
    }

    public Item getResult() {
        return Items.AIR;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        BacteriaIncubationRecipe recipe = new BacteriaIncubationRecipe(this.bacteria, this.nutrient, this.growth, this.consumeChance);
        recipeOutput.accept(resourceLocation, (Recipe)recipe, null);
    }

    @Override
    public void save(RecipeOutput output) {
        StringBuilder builder = new StringBuilder();
        StringBuilder valuesStr = new StringBuilder();
        Ingredient.Value[] values = this.nutrient.getValues();
        ArrayList stacks = new ArrayList();
        for (Ingredient.Value value : values) {
            stacks.addAll(value.getItems());
        }
        for (ItemStack stack : stacks) {
            ResourceLocation itemLocation = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            valuesStr.append("_").append(itemLocation.getPath().replace(':', '-'));
        }
        builder.append(this.bacteria().location().toString().replace(':', '-')).append(valuesStr.toString());
        this.save(output, ResourceLocation.fromNamespaceAndPath((String)"nautec", (String)(this.getName() + "/" + String.valueOf(builder))));
    }

    @Override
    public List<Ingredient> getIngredients() {
        return Collections.singletonList(this.nutrient);
    }

    @Override
    public String getName() {
        return "bacteria_incubation";
    }
}

