/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.events;

import com.portingdeadmods.nautec.api.augments.Augment;
import com.portingdeadmods.nautec.api.augments.AugmentSlot;
import com.portingdeadmods.nautec.client.renderer.augments.helper.GuardianEyeRenderHelper;
import com.portingdeadmods.nautec.content.augments.GuardianEyeAugment;
import com.portingdeadmods.nautec.events.helper.AugmentLayerRenderer;
import com.portingdeadmods.nautec.events.helper.AugmentSlotsRenderer;
import java.util.Map;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(modid="nautec", value={Dist.CLIENT})
public final class AugmentClientEvents {
    @SubscribeEvent
    public static void renderPlayerPart(RenderPlayerEvent.Pre event) {
        AugmentSlotsRenderer.render(event);
    }

    @SubscribeEvent
    public static void onRenderPlayer(RenderPlayerEvent.Post event) {
        Map<AugmentSlot, Augment> augments = AugmentLayerRenderer.AUGMENTS_CACHE;
        for (Augment augment : augments.values()) {
            GuardianEyeAugment eyeAugment;
            if (augment == null || !(augment instanceof GuardianEyeAugment) || (eyeAugment = (GuardianEyeAugment)augment).getTargetEntity() == null) continue;
            GuardianEyeRenderHelper.render(event.getEntity(), eyeAugment, event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource());
            return;
        }
    }

    @SubscribeEvent
    public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        AugmentLayerRenderer.AUGMENTS_CACHE.clear();
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            AugmentLayerRenderer.AUGMENTS_CACHE.clear();
        }
    }
}

