/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.mixin;

import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.registries.NTFluids;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BucketItem.class})
public abstract class BucketItemMixin {
    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUse(Level level, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (NTConfig.collectSaltWater) {
            BlockPos blockPos;
            BlockState blockState;
            Block block;
            ItemStack itemStack = player.getItemInHand(hand);
            BlockHitResult blockHitResult = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (blockHitResult.getType() == HitResult.Type.BLOCK && (block = (blockState = level.getBlockState(blockPos = blockHitResult.getBlockPos())).getBlock()) instanceof BucketPickup) {
                ItemStack filledBucket;
                BucketPickup bucketPickup = (BucketPickup)block;
                if (level.getFluidState(blockPos).is(FluidTags.WATER) && level.getBiome(blockPos).getRegisteredName().contains("ocean") && !(filledBucket = bucketPickup.pickupBlock(player, (LevelAccessor)level, blockPos, blockState)).isEmpty()) {
                    filledBucket = new ItemStack((ItemLike)NTFluids.SALT_WATER.getBucket());
                    player.awardStat(Stats.ITEM_USED.get((Object)Items.BUCKET));
                    bucketPickup.getPickupSound(blockState).ifPresent(soundEvent -> level.playSound(player, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f));
                    if (!level.isClientSide) {
                        CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, filledBucket);
                    }
                    cir.setReturnValue((Object)InteractionResultHolder.sidedSuccess((Object)ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)filledBucket), (boolean)level.isClientSide()));
                    cir.cancel();
                }
            }
        }
    }
}

