/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.mixin;

import com.portingdeadmods.nautec.NTConfig;
import com.portingdeadmods.nautec.utils.NTProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={KelpBlock.class})
public abstract class KelpBlockMixin
extends GrowingPlantHeadBlock {
    protected KelpBlockMixin(BlockBehaviour.Properties properties, Direction growthDirection, VoxelShape shape, boolean scheduleFluidTicks, double growPerTickProbability) {
        super(properties, growthDirection, shape, scheduleFluidTicks, growPerTickProbability);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NTProperties.KELP_AGE});
    }

    @NotNull
    public BlockState getStateForPlacement(LevelAccessor level) {
        return (BlockState)this.defaultBlockState().setValue((Property)NTProperties.KELP_AGE, (Comparable)Integer.valueOf(level.getRandom().nextInt(NTConfig.kelpHeight + 1)));
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)NTProperties.KELP_AGE) < NTConfig.kelpHeight;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos blockpos;
        if ((Integer)state.getValue((Property)NTProperties.KELP_AGE) < NTConfig.kelpHeight && CommonHooks.canCropGrow((Level)level, (BlockPos)pos.relative(this.growthDirection), (BlockState)state, (random.nextDouble() < 0.14 ? 1 : 0) != 0) && this.canGrowInto(level.getBlockState(blockpos = pos.relative(this.growthDirection)))) {
            BlockState growState = this.getGrowIntoState(state, random);
            level.setBlockAndUpdate(blockpos, growState);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)blockpos, (BlockState)level.getBlockState(blockpos));
        }
    }

    @NotNull
    protected BlockState getGrowIntoState(BlockState state, RandomSource random) {
        int currentAge = (Integer)state.getValue((Property)NTProperties.KELP_AGE);
        return (BlockState)state.setValue((Property)NTProperties.KELP_AGE, (Comparable)Integer.valueOf(Math.min(currentAge + 1, NTConfig.kelpHeight)));
    }

    @NotNull
    public BlockState getMaxAgeState(BlockState state) {
        return (BlockState)state.setValue((Property)NTProperties.KELP_AGE, (Comparable)Integer.valueOf(NTConfig.kelpHeight));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.getValue((Property)NTProperties.KELP_AGE) == NTConfig.kelpHeight;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.relative(this.growthDirection);
        int i = Math.min((Integer)state.getValue((Property)NTProperties.KELP_AGE) + 1, NTConfig.kelpHeight);
        int j = this.getBlocksToGrowWhenBonemealed(random);
        for (int k = 0; k < j && this.canGrowInto(level.getBlockState(blockpos)); ++k) {
            level.setBlockAndUpdate(blockpos, (BlockState)state.setValue((Property)NTProperties.KELP_AGE, (Comparable)Integer.valueOf(i)));
            blockpos = blockpos.relative(this.growthDirection);
            i = Math.min(i + 1, NTConfig.kelpHeight);
        }
    }
}

