/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.utils.codec;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Lifecycle;
import java.util.List;
import java.util.function.UnaryOperator;

public interface SetBuilder<T> {
    public DynamicOps<T> ops();

    public DataResult<T> build(T var1);

    public SetBuilder<T> add(T var1);

    public SetBuilder<T> add(DataResult<T> var1);

    public SetBuilder<T> withErrorsFrom(DataResult<?> var1);

    public SetBuilder<T> mapError(UnaryOperator<String> var1);

    default public DataResult<T> build(DataResult<T> prefix) {
        return prefix.flatMap(this::build);
    }

    default public <E> SetBuilder<T> add(E value, Encoder<E> encoder) {
        return this.add(encoder.encodeStart(this.ops(), value));
    }

    default public <E> SetBuilder<T> addAll(Iterable<E> values, Encoder<E> encoder) {
        values.forEach(v -> encoder.encode(v, this.ops(), this.ops().empty()));
        return this;
    }

    public static final class Builder<T>
    implements SetBuilder<T> {
        private final DynamicOps<T> ops;
        private DataResult<ImmutableSet.Builder<T>> builder = DataResult.success((Object)ImmutableSet.builder(), (Lifecycle)Lifecycle.stable());

        public Builder(DynamicOps<T> ops) {
            this.ops = ops;
        }

        @Override
        public DynamicOps<T> ops() {
            return this.ops;
        }

        @Override
        public SetBuilder<T> add(T value) {
            this.builder = this.builder.map(b -> b.add(value));
            return this;
        }

        @Override
        public SetBuilder<T> add(DataResult<T> value) {
            this.builder = this.builder.apply2stable(ImmutableSet.Builder::add, value);
            return this;
        }

        @Override
        public SetBuilder<T> withErrorsFrom(DataResult<?> result) {
            this.builder = this.builder.flatMap(r -> result.map(v -> r));
            return this;
        }

        @Override
        public SetBuilder<T> mapError(UnaryOperator<String> onError) {
            this.builder = this.builder.mapError(onError);
            return this;
        }

        @Override
        public DataResult<T> build(T prefix) {
            DataResult result = this.builder.flatMap(b -> this.ops.mergeToList(prefix, (List)b.build().asList()));
            this.builder = DataResult.success((Object)ImmutableSet.builder(), (Lifecycle)Lifecycle.stable());
            return result;
        }
    }
}

