/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.utils.ranges;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.function.BiFunction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public abstract class AbstractRange<T extends Number> {
    private final T min;
    private final T max;
    private final Collection<T> possibleValues;

    protected AbstractRange(T minInclusive, T maxInclusive) {
        this.min = minInclusive;
        this.max = maxInclusive;
        this.possibleValues = this.collectPossibleValues();
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public Collection<T> getPossibleValues() {
        return this.possibleValues;
    }

    protected abstract Collection<T> collectPossibleValues();

    public String toString() {
        return String.valueOf(this.min) + " - " + String.valueOf(this.max);
    }

    public static <T extends Number, SELF extends AbstractRange<T>> MapCodec<SELF> rangeMapCodec(Codec<T> codec, BiFunction<T, T, SELF> constructor) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)codec.fieldOf("min").forGetter(AbstractRange::getMin), (App)codec.fieldOf("max").forGetter(AbstractRange::getMax)).apply((Applicative)instance, constructor));
    }

    public static <T extends Number, SELF extends AbstractRange<T>> StreamCodec<RegistryFriendlyByteBuf, SELF> rangeStreamCodec(StreamCodec<ByteBuf, T> streamCodec, BiFunction<T, T, SELF> constructor) {
        return StreamCodec.composite(streamCodec, AbstractRange::getMin, streamCodec, AbstractRange::getMax, constructor);
    }
}

