/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import wardentools.block.AbyssDoublePlantBlock;
import wardentools.block.AbyssPortalBlock;
import wardentools.block.BlackLanternBlock;
import wardentools.block.BlueBush;
import wardentools.block.ContagionIncarnationSkullBlock;
import wardentools.block.CrystalBlock;
import wardentools.block.CrystalInfuserBlock;
import wardentools.block.DarkDirtBlock;
import wardentools.block.DarkGrassBlock;
import wardentools.block.DysfunctionningCatalystBlock;
import wardentools.block.GolemStoneBlock;
import wardentools.block.GramophoneBlock;
import wardentools.block.LiquidCorruptionBlock;
import wardentools.block.LivingSproutBlock;
import wardentools.block.ModFlammableRotatedPillarBlock;
import wardentools.block.ProtectorInvokerBlock;
import wardentools.block.RadianceCatalystBlock;
import wardentools.block.RadianceCrystalBlock;
import wardentools.block.SolidCorruptionBlock;
import wardentools.block.SonicBlaster;
import wardentools.block.SoulSpawner;
import wardentools.block.WindWhispererBlock;
import wardentools.block.depthvines.DepthVines;
import wardentools.block.depthvines.DepthVinesBlock;
import wardentools.block.depthvines.DepthVinesPlantBlock;
import wardentools.block.sculktendril.SculkTendrilBlock;
import wardentools.fluid.FluidRegistry;
import wardentools.misc.Crystal;
import wardentools.worldgen.features.ModConfiguredFeatures;

public class BlockRegistry {
    public static final DeferredRegister<Block> REGISTAR = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"wardentools");
    private static final int LIGHT_DARK_TREE = 6;
    private static final int LIGHT_WHITE_TREE = 10;
    private static final int LIGHT_WHITE_VEGETATION = 8;
    private static final int LIGHT_DARK_VEGETATION = 5;
    private static final MapColor DARKTREE_COLOR = MapColor.TERRACOTTA_BLUE;
    private static final MapColor DARKTREE_FOLIAGE_COLOR = MapColor.COLOR_CYAN;
    private static final MapColor DARK_VEGETATION_COLOR = MapColor.COLOR_CYAN;
    private static final MapColor WHITE_TREE_COLOR = MapColor.TERRACOTTA_CYAN;
    private static final MapColor DARKGRASS_COLOR = MapColor.TERRACOTTA_GREEN;
    public static final RegistryObject<Block> DEEPBLOCK = REGISTAR.register("deepblock", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OBSIDIAN)));
    public static final RegistryObject<Block> DEEP_CRISTAL = REGISTAR.register("deepcristal", () -> new CrystalBlock(7.0f, 3.0f, 0, Crystal.ECHO, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_CLUSTER).mapColor(MapColor.COLOR_BLACK).requiresCorrectToolForDrops().strength(30.0f, 900.0f)));
    public static final RegistryObject<Block> RADIANCE_CRISTAL = REGISTAR.register("radiance_cristal", () -> new RadianceCrystalBlock(10.0f, 5.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_CLUSTER).mapColor(MapColor.COLOR_LIGHT_BLUE).requiresCorrectToolForDrops().lightLevel(state -> 11).strength(20.0f, 700.0f)));
    public static final RegistryObject<Block> DARKTREE_LOG = REGISTAR.register("darktree_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).mapColor(DARKTREE_COLOR).strength(4.0f).lightLevel(state -> 6)));
    public static final RegistryObject<Block> DARKTREE_WOOD = REGISTAR.register("darktree_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD).mapColor(DARKTREE_COLOR).strength(4.0f).lightLevel(state -> 6)));
    public static final RegistryObject<Block> STRIPPED_DARKTREE_LOG = REGISTAR.register("stripped_darktree_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG).mapColor(DARKTREE_COLOR).strength(4.0f).lightLevel(state -> 6)));
    public static final RegistryObject<Block> STRIPPED_DARKTREE_WOOD = REGISTAR.register("stripped_darktree_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD).mapColor(DARKTREE_COLOR).strength(4.0f).lightLevel(state -> 6)));
    public static final RegistryObject<Block> DARKTREE_PLANKS = REGISTAR.register("darktree_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).mapColor(DARKTREE_COLOR).lightLevel(state -> 6)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final RegistryObject<Block> DARKTREE_STAIR = REGISTAR.register("darktree_stair", () -> new StairBlock(Blocks.OAK_STAIRS.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS).mapColor(DARKTREE_COLOR).lightLevel(state -> 6)));
    public static final RegistryObject<Block> DARKTREE_SLAB = REGISTAR.register("darktree_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB).mapColor(DARKTREE_COLOR).lightLevel(state -> 6)));
    public static final RegistryObject<Block> DARKTREE_BUTTON = REGISTAR.register("darktree_button", () -> new ButtonBlock(BlockSetType.OAK, 10, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON).mapColor(DARKTREE_COLOR).lightLevel(state -> 6)));
    public static final RegistryObject<Block> DARKTREE_PRESSURE_PLATE = REGISTAR.register("darktree_pressure_plate", () -> new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE).mapColor(DARKTREE_COLOR).lightLevel(state -> 6)));
    public static final RegistryObject<Block> DARKTREE_FENCE = REGISTAR.register("darktree_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE).mapColor(DARKTREE_COLOR).lightLevel(state -> 6)));
    public static final RegistryObject<Block> DARKTREE_FENCE_GATE = REGISTAR.register("darktree_fence_gate", () -> new FenceGateBlock(WoodType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE).mapColor(DARKTREE_COLOR).lightLevel(state -> 6)));
    public static final RegistryObject<Block> DARKTREE_DOOR = REGISTAR.register("darktree_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).lightLevel(state -> 6).mapColor(DARKTREE_COLOR).noOcclusion()));
    public static final RegistryObject<Block> DARKTREE_TRAPDOOR = REGISTAR.register("darktree_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).lightLevel(state -> 6).mapColor(DARKTREE_COLOR).noOcclusion()));
    public static final RegistryObject<Block> DARKTREE_LEAVES = REGISTAR.register("darktree_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(DARKTREE_FOLIAGE_COLOR).lightLevel(state -> 8)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 60;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 30;
        }
    });
    public static final RegistryObject<Block> DARKTREE_SAPLING = REGISTAR.register("darktree_sapling", () -> new SaplingBlock(new TreeGrower("darktree", Optional.of(ModConfiguredFeatures.DARKTREE_KEY), Optional.of(ModConfiguredFeatures.DARKTREE_KEY), Optional.of(ModConfiguredFeatures.DARKTREE_KEY)), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING).mapColor(DARKTREE_COLOR).lightLevel(state -> 6)));
    public static final RegistryObject<Block> DARKGRASS_BLOCK = REGISTAR.register("darkgrass_block", () -> new DarkGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).mapColor(DARKGRASS_COLOR).strength(0.9f).sound(SoundType.GRASS).randomTicks()));
    public static final RegistryObject<Block> DARKDIRT = REGISTAR.register("darkdirt", () -> new DarkDirtBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).mapColor(MapColor.COLOR_BLACK).strength(0.8f).randomTicks()));
    public static final RegistryObject<Block> WHITETREE_LOG = REGISTAR.register("whitetree_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).mapColor(WHITE_TREE_COLOR).strength(4.0f).lightLevel(state -> 10)));
    public static final RegistryObject<Block> WHITETREE_WOOD = REGISTAR.register("whitetree_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD).mapColor(WHITE_TREE_COLOR).strength(4.0f).lightLevel(state -> 10)));
    public static final RegistryObject<Block> STRIPPED_WHITETREE_LOG = REGISTAR.register("stripped_whitetree_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG).mapColor(WHITE_TREE_COLOR).strength(4.0f).lightLevel(state -> 10)));
    public static final RegistryObject<Block> STRIPPED_WHITETREE_WOOD = REGISTAR.register("stripped_whitetree_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD).mapColor(WHITE_TREE_COLOR).strength(4.0f).lightLevel(state -> 10)));
    public static final RegistryObject<Block> WHITETREE_LEAVES = REGISTAR.register("whitetree_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(DyeColor.WHITE).lightLevel(state -> 12)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 60;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 30;
        }
    });
    public static final RegistryObject<Block> WHITETREE_SAPLING = REGISTAR.register("whitetree_sapling", () -> new SaplingBlock(new TreeGrower("whitetree", Optional.of(ModConfiguredFeatures.WHITETREE_KEY), Optional.of(ModConfiguredFeatures.WHITETREE_KEY), Optional.of(ModConfiguredFeatures.WHITETREE_KEY)), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING).mapColor(WHITE_TREE_COLOR).lightLevel(state -> 12)));
    public static final RegistryObject<Block> WHITETREE_PLANKS = REGISTAR.register("whitetree_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).mapColor(WHITE_TREE_COLOR).lightLevel(state -> 10)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final RegistryObject<Block> WHITETREE_STAIR = REGISTAR.register("whitetree_stair", () -> new StairBlock(Blocks.OAK_STAIRS.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS).mapColor(WHITE_TREE_COLOR).lightLevel(state -> 10)));
    public static final RegistryObject<Block> WHITETREE_SLAB = REGISTAR.register("whitetree_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB).mapColor(WHITE_TREE_COLOR).lightLevel(state -> 10)));
    public static final RegistryObject<Block> WHITETREE_BUTTON = REGISTAR.register("whitetree_button", () -> new ButtonBlock(BlockSetType.OAK, 10, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON).mapColor(WHITE_TREE_COLOR).lightLevel(state -> 10)));
    public static final RegistryObject<Block> WHITETREE_PRESSURE_PLATE = REGISTAR.register("whitetree_pressure_plate", () -> new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE).mapColor(WHITE_TREE_COLOR).lightLevel(state -> 10)));
    public static final RegistryObject<Block> WHITETREE_FENCE = REGISTAR.register("whitetree_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE).mapColor(WHITE_TREE_COLOR).lightLevel(state -> 10)));
    public static final RegistryObject<Block> WHITETREE_FENCE_GATE = REGISTAR.register("whitetree_fence_gate", () -> new FenceGateBlock(WoodType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE).mapColor(WHITE_TREE_COLOR).lightLevel(state -> 10)));
    public static final RegistryObject<Block> WHITETREE_DOOR = REGISTAR.register("whitetree_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).mapColor(WHITE_TREE_COLOR).lightLevel(state -> 10).noOcclusion()));
    public static final RegistryObject<Block> WHITETREE_TRAPDOOR = REGISTAR.register("whitetree_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).mapColor(WHITE_TREE_COLOR).lightLevel(state -> 10).noOcclusion()));
    public static final RegistryObject<Block> TALL_WHITE_GRASS = REGISTAR.register("tall_white_grass", () -> new DoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS).mapColor(DyeColor.WHITE).noOcclusion().noCollission().lightLevel(state -> 8)));
    public static final RegistryObject<Block> WHITE_GRASS = REGISTAR.register("white_grass", () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS).mapColor(DyeColor.WHITE).noOcclusion().noCollission().lightLevel(state -> 8)));
    public static final RegistryObject<Block> WHITE_TORCHFLOWER = REGISTAR.register("white_torchflower", () -> new FlowerBlock(MobEffects.LUCK, 5.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCHFLOWER).noOcclusion().mapColor(DyeColor.CYAN).noCollission().lightLevel(state -> 10)));
    public static final RegistryObject<Block> POTTED_WHITE_TORCHFLOWER = REGISTAR.register("potted_white_torchflower", () -> new FlowerPotBlock((Block)WHITE_TORCHFLOWER.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_ALLIUM).noOcclusion().lightLevel(state -> 10)));
    public static final RegistryObject<RadianceCatalystBlock> RADIANCE_CATALYST = REGISTAR.register("radiance_catalyst", () -> new RadianceCatalystBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEACON).strength(5.0f, 15.0f).mapColor(DyeColor.CYAN).noOcclusion().lightLevel(state -> 10)));
    public static final RegistryObject<Block> DEEPFLOWER = REGISTAR.register("deepflower", () -> new AbyssDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS).noOcclusion().mapColor(DARK_VEGETATION_COLOR).noCollission().lightLevel(state -> 5)));
    public static final RegistryObject<Block> BLUE_BUSH = REGISTAR.register("blue_bush", () -> new BlueBush(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS).mapColor(DARK_VEGETATION_COLOR).noOcclusion().noCollission().lightLevel(state -> state.getValue(BlueBush.BERRY_STATE) == BlueBush.BerryState.BLUE_BERRY ? 8 : 5)));
    public static final RegistryObject<Block> TALL_DARK_GRASS = REGISTAR.register("tall_dark_grass", () -> new AbyssDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS).mapColor(DARK_VEGETATION_COLOR).noOcclusion().noCollission().lightLevel(state -> 5)));
    public static final RegistryObject<Block> DARK_GRASS = REGISTAR.register("dark_grass", () -> new TallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS).mapColor(DARK_VEGETATION_COLOR).noOcclusion().noCollission().lightLevel(state -> 5)));
    public static final RegistryObject<Block> PROTECTOR_INVOKER = REGISTAR.register("protector_invoker", () -> new ProtectorInvokerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEACON).strength(5.0f, 15.0f).mapColor(DyeColor.CYAN).noOcclusion().lightLevel(state -> 10)));
    public static final RegistryObject<Block> ABYSSALITE = REGISTAR.register("abyssalite", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE).strength(4.0f, 7.0f)));
    public static final RegistryObject<Block> CHISELED_ABYSSALITE = REGISTAR.register("chiseled_abyssalite", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE).strength(4.0f, 7.0f)));
    public static final RegistryObject<Block> ABYSSALITE_BRICKS = REGISTAR.register("abyssalite_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE).strength(4.0f, 7.0f)));
    public static final RegistryObject<Block> CRACKED_ABYSSALITE_BRICKS = REGISTAR.register("cracked_abyssalite_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE).strength(4.0f, 7.0f)));
    public static final RegistryObject<Block> ABYSSALITE_BRICKS_STAIRS = REGISTAR.register("abyssalite_bricks_stair", () -> new StairBlock(Blocks.BLACKSTONE_STAIRS.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE_STAIRS).strength(4.0f, 7.0f)));
    public static final RegistryObject<Block> ABYSSALITE_BRICKS_SLAB = REGISTAR.register("abyssalite_bricks_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE_SLAB).strength(4.0f, 7.0f)));
    public static final RegistryObject<Block> ABYSSALITE_BRICKS_WALL = REGISTAR.register("abyssalite_bricks_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE_WALL).strength(4.0f, 7.0f)));
    public static final RegistryObject<DropExperienceBlock> ABYSSALITE_COAL_ORE = REGISTAR.register("abyssalite_coal_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)1, (int)3), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE).strength(5.0f, 8.0f)));
    public static final RegistryObject<DropExperienceBlock> ABYSSALITE_LAPIS_ORE = REGISTAR.register("abyssalite_lapis_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)6), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE).strength(5.0f, 8.0f)));
    public static final RegistryObject<DropExperienceBlock> ABYSSALITE_DIAMOND_ORE = REGISTAR.register("abyssalite_diamond_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)4, (int)8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE).strength(5.0f, 8.0f)));
    public static final RegistryObject<DropExperienceBlock> ABYSSALITE_DEEP_ORE = REGISTAR.register("abyssalite_deep_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)7, (int)10), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE).strength(6.0f, 9.0f)));
    public static final RegistryObject<RedStoneOreBlock> ABYSSALITE_REDSTONE_ORE = REGISTAR.register("abyssalite_redstone_ore", () -> new RedStoneOreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_ORE).strength(5.0f, 8.0f)));
    public static final RegistryObject<LiquidCorruptionBlock> LIQUID_CORRUPTION_BLOCK = REGISTAR.register("liquid_corruption_block", () -> new LiquidCorruptionBlock((Supplier<? extends FlowingFluid>)FluidRegistry.SOURCE_LIQUID_CORRUPTION, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAVA).mapColor(MapColor.COLOR_BLACK).speedFactor(0.5f)));
    public static final RegistryObject<Block> PALE_CRISTAL = REGISTAR.register("pale_cristal", () -> new CrystalBlock(11.0f, 4.0f, 8, Crystal.PALE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_CLUSTER).requiresCorrectToolForDrops().mapColor(MapColor.COLOR_LIGHT_BLUE).strength(3.0f, 6.0f).lightLevel(CrystalBlock::getLightLevel)));
    public static final RegistryObject<Block> PALE_CRISTAL_BLOCK = REGISTAR.register("pale_cristal_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).strength(4.0f, 7.0f).mapColor(MapColor.COLOR_LIGHT_BLUE).requiresCorrectToolForDrops().lightLevel(state -> 8)));
    public static final RegistryObject<Block> CITRINE = REGISTAR.register("citrine", () -> new CrystalBlock(9.0f, 4.0f, 8, Crystal.CITRINE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_CLUSTER).requiresCorrectToolForDrops().mapColor(MapColor.COLOR_YELLOW).strength(3.0f, 6.0f).lightLevel(CrystalBlock::getLightLevel)));
    public static final RegistryObject<Block> CITRINE_BLOCK = REGISTAR.register("citrine_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).strength(3.0f, 6.0f).mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops().lightLevel(state -> 8)));
    public static final RegistryObject<Block> ECHO_CRISTAL = REGISTAR.register("echo_cristal", () -> new CrystalBlock(10.0f, 5.0f, 3, Crystal.ECHO, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_CLUSTER).requiresCorrectToolForDrops().mapColor(MapColor.COLOR_BLACK).strength(3.0f, 6.0f).lightLevel(CrystalBlock::getLightLevel)));
    public static final RegistryObject<Block> ECHO_BLOCK = REGISTAR.register("echo_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).strength(3.0f, 6.0f).mapColor(MapColor.COLOR_BLACK).requiresCorrectToolForDrops().lightLevel(state -> 3)));
    public static final RegistryObject<Block> RUBY = REGISTAR.register("ruby", () -> new CrystalBlock(7.0f, 3.0f, 6, Crystal.RUBY, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_CLUSTER).requiresCorrectToolForDrops().mapColor(MapColor.COLOR_RED).strength(4.0f, 7.0f).lightLevel(CrystalBlock::getLightLevel)));
    public static final RegistryObject<Block> RUBY_BLOCK = REGISTAR.register("ruby_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).strength(3.0f, 6.0f).mapColor(MapColor.COLOR_RED).requiresCorrectToolForDrops().lightLevel(state -> 6)));
    public static final RegistryObject<Block> MALACHITE = REGISTAR.register("malachite", () -> new CrystalBlock(7.0f, 3.0f, 6, Crystal.MALACHITE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_CLUSTER).requiresCorrectToolForDrops().mapColor(MapColor.COLOR_GREEN).strength(4.0f, 7.0f).lightLevel(CrystalBlock::getLightLevel)));
    public static final RegistryObject<Block> MALACHITE_BLOCK = REGISTAR.register("malachite_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).strength(3.0f, 6.0f).mapColor(MapColor.COLOR_GREEN).requiresCorrectToolForDrops().lightLevel(state -> 6)));
    public static final RegistryObject<AbyssPortalBlock> ABYSS_PORTAL_BLOCK = REGISTAR.register("abyss_portal", () -> new AbyssPortalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_PORTAL).noCollission().forceSolidOn().mapColor(MapColor.COLOR_BLACK).lightLevel(state -> 10)));
    public static final RegistryObject<Block> SOLID_CORRUPTION = REGISTAR.register("solid_corruption", () -> new SolidCorruptionBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OBSIDIAN).lightLevel(state -> 3).mapColor(MapColor.COLOR_BLACK).randomTicks()));
    public static final RegistryObject<Block> DYSFUNCTIONNING_CATALYST = REGISTAR.register("dysfunctionning_catalyst", () -> new DysfunctionningCatalystBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)RADIANCE_CATALYST.get())).mapColor(MapColor.TERRACOTTA_BLUE).strength(-1.0f).lightLevel(state -> 3)));
    public static final RegistryObject<Block> BLACK_LANTERN = REGISTAR.register("black_lantern", () -> new BlackLanternBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SEA_LANTERN).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 5).strength(3.5f, 10.0f).mapColor(MapColor.TERRACOTTA_CYAN).randomTicks()));
    public static final RegistryObject<Block> CRACKED_ABYSSALITE_BRICKS_STAIR = REGISTAR.register("cracked_abyssalite_bricks_stair", () -> new StairBlock(((Block)CRACKED_ABYSSALITE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE_STAIRS).strength(4.0f, 7.0f)));
    public static final RegistryObject<Block> CRACKED_ABYSSALITE_BRICKS_SLAB = REGISTAR.register("cracked_abyssalite_bricks_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE_SLAB).strength(4.0f, 7.0f)));
    public static final RegistryObject<Block> CRACKED_ABYSSALITE_BRICKS_WALL = REGISTAR.register("cracked_abyssalite_bricks_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE_WALL).strength(4.0f, 7.0f)));
    public static final RegistryObject<Block> CONTAGION_INCARNATION_SKULL = REGISTAR.register("contagion_incarnation_skull", () -> new ContagionIncarnationSkullBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SKELETON_SKULL).strength(4.0f, 7.0f).noOcclusion()));
    public static final RegistryObject<Block> REINFORCED_GLASS = REGISTAR.register("reinforced_glass", () -> new Block(BlockBehaviour.Properties.of().sound(SoundType.GLASS).mapColor(MapColor.COLOR_GRAY).strength(3.0f, 6.0f).noOcclusion()));
    public static final RegistryObject<Block> WIND_WHISPERER = REGISTAR.register("wind_whisperer", () -> new WindWhispererBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEACON).strength(2.0f, 3.0f).noOcclusion().randomTicks().lightLevel(state -> 10)));
    public static final RegistryObject<Block> SOUL_SPAWNER = REGISTAR.register("soul_spawner", () -> new SoulSpawner(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPAWNER).strength(3.0f).noOcclusion().randomTicks().lightLevel(state -> 2)));
    public static final RegistryObject<Block> GRAMOPHONE = REGISTAR.register("gramophone", () -> new GramophoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JUKEBOX).strength(3.0f, 6.0f).noOcclusion()));
    public static final RegistryObject<Block> SONIC_BLASTER = REGISTAR.register("sonic_blaster", () -> new SonicBlaster(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DISPENSER).strength(5.5f).lightLevel(state -> 3)));
    public static final RegistryObject<Block> DEPTH_VINES = REGISTAR.register("depth_vines", () -> new DepthVinesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().noCollission().lightLevel(DepthVines.emission(14)).instabreak().sound(SoundType.CAVE_VINES).pushReaction(PushReaction.DESTROY)));
    public static final RegistryObject<Block> DEPTH_VINES_PLANT = REGISTAR.register("depth_vines_plant", () -> new DepthVinesPlantBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().lightLevel(DepthVines.emission(14)).instabreak().sound(SoundType.CAVE_VINES).pushReaction(PushReaction.DESTROY)));
    public static final RegistryObject<Block> SCULK_TENDRIL_BLOCK = REGISTAR.register("sculk_tendril_block", () -> new SculkTendrilBlock((IntProvider)UniformInt.of((int)3, (int)6), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SCULK).noOcclusion().dynamicShape().forceSolidOn().pushReaction(PushReaction.DESTROY)));
    public static final RegistryObject<Block> CORRUPTED_ABYSSALITE = REGISTAR.register("corrupted_abyssalite", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLACKSTONE).strength(4.0f, 7.0f)));
    public static final RegistryObject<Block> LIVING_SPROUT = REGISTAR.register("living_sprout", () -> new LivingSproutBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SCULK).noOcclusion().sound(SoundType.SCULK_SENSOR).lightLevel(state -> 1).emissiveRendering((state, blockGetter, pos) -> LivingSproutBlock.getPhase(state) == SculkSensorPhase.ACTIVE)));
    public static final RegistryObject<Block> CRYSTAL_INFUSER = REGISTAR.register("crystal_infuser", () -> new CrystalInfuserBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK).noOcclusion()));
    public static final RegistryObject<Block> GOLEM_STONE = REGISTAR.register("golem_stone", () -> new GolemStoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK)));

    private static boolean never(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    private static boolean always(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }
}

