/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import wardentools.items.ItemRegistry;

public class BlueBush
extends TallGrassBlock
implements BonemealableBlock {
    public static final EnumProperty<BerryState> BERRY_STATE = EnumProperty.create((String)"berry_state", BerryState.class);

    public BlueBush(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(BERRY_STATE, (Comparable)((Object)BerryState.NONE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{BERRY_STATE});
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource randomSource, @NotNull BlockPos pos, @NotNull BlockState state) {
        if (state.getValue(BERRY_STATE) == BerryState.NONE) {
            level.setBlock(pos, (BlockState)state.setValue(BERRY_STATE, (Comparable)((Object)BerryState.BLUE_BERRY)), 3);
        } else {
            this.throwBlueGlowBerry(level, pos);
        }
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (state.getValue(BERRY_STATE) == BerryState.BLUE_BERRY) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)state.setValue(BERRY_STATE, (Comparable)((Object)BerryState.NONE)), 3);
                this.throwBlueGlowBerry((ServerLevel)level, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (state.getValue(BERRY_STATE) == BerryState.BLUE_BERRY) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)state.setValue(BERRY_STATE, (Comparable)((Object)BerryState.NONE)), 3);
                this.throwBlueGlowBerry((ServerLevel)level, pos);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    private void throwBlueGlowBerry(ServerLevel level, BlockPos pos) {
        Vec3 direction = Vec3.atLowerCornerWithOffset((Vec3i)pos, (double)0.5, (double)1.01, (double)0.5).offsetRandom(level.random, 0.5f);
        ItemStack item = new ItemStack((ItemLike)ItemRegistry.BLUE_GLOW_BERRIES.get());
        ItemEntity itemEntity = new ItemEntity((Level)level, direction.x(), direction.y(), direction.z(), item);
        itemEntity.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)itemEntity);
    }

    public static enum BerryState implements StringRepresentable
    {
        NONE,
        BLUE_BERRY;


        @NotNull
        public String getSerializedName() {
            return this == BLUE_BERRY ? "blue_berry" : "none";
        }

        public String toString() {
            return this.getSerializedName();
        }
    }
}

