/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wardentools.blockentity.BlockEntityRegistry;
import wardentools.blockentity.DysfunctionningCatalystBlockEntity;

public class DysfunctionningCatalystBlock
extends Block
implements EntityBlock {
    public DysfunctionningCatalystBlock(BlockBehaviour.Properties prop) {
        super(prop);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.DYSFUNCTIONNING_CATALYST_BLOCK_ENTITY.get()).create(pos, state);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        return this.use(level, pos, player);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        switch (this.use(level, pos, player)) {
            case SUCCESS: {
                return ItemInteractionResult.SUCCESS;
            }
            case FAIL: {
                return ItemInteractionResult.FAIL;
            }
            case PASS: {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public InteractionResult use(Level level, @NotNull BlockPos pos, @NotNull Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof DysfunctionningCatalystBlockEntity)) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            sPlayer.openMenu((MenuProvider)blockEntity, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return level.isClientSide() ? (level0, pos0, state0, blockEntity) -> ((DysfunctionningCatalystBlockEntity)blockEntity).clientTick() : (level0, pos0, state0, blockEntity) -> ((DysfunctionningCatalystBlockEntity)blockEntity).tick();
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockEntity be;
        if (!level.isClientSide() && (be = level.getBlockEntity(pos)) instanceof DysfunctionningCatalystBlockEntity) {
            DysfunctionningCatalystBlockEntity blockEntity = (DysfunctionningCatalystBlockEntity)be;
            ItemStackHandler inventory = blockEntity.getInventory();
            for (int index = 0; index < inventory.getSlots(); ++index) {
                ItemStack stackDrop = inventory.getStackInSlot(index);
                ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stackDrop);
                level.addFreshEntity((Entity)entity);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DysfunctionningCatalystBlockEntity) {
            DysfunctionningCatalystBlockEntity catalyst = (DysfunctionningCatalystBlockEntity)blockEntity;
            catalyst.clientTick();
        }
    }
}

