/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;
import wardentools.effect.ModEffects;
import wardentools.misc.CustomDamageType;
import wardentools.particle.ParticleRegistry;

public class LiquidCorruptionBlock
extends LiquidBlock {
    private static final int PARTICLE_PERDIOD = 30;
    private static final double PARTICLE_SPEED = 0.1;

    @Deprecated
    public LiquidCorruptionBlock(FlowingFluid flowingFluid, BlockBehaviour.Properties properties) {
        super(flowingFluid, properties);
    }

    public LiquidCorruptionBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties properties) {
        super(supplier, properties);
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        return false;
    }

    public void entityInside(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Entity entity) {
        LivingEntity living;
        super.entityInside(blockState, level, blockPos, entity);
        if (!entity.level().isClientSide && entity instanceof LivingEntity && (living = (LivingEntity)entity).level().getGameTime() % 20L == 1L) {
            if (ModEffects.PURIFIED.getHolder().isPresent() && living.hasEffect((Holder)ModEffects.PURIFIED.getHolder().get())) {
                return;
            }
            living.addEffect(new MobEffectInstance((Holder)ModEffects.CORRUPTED.getHolder().get(), 400, 1, false, false));
            Holder.Reference corruptedDamageTypeHolder = living.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(CustomDamageType.CORRUPTED_KEY);
            living.hurt(new DamageSource((Holder)corruptedDamageTypeHolder, null, (Entity)living, null), 3.0f);
        }
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos neighborPos, boolean isMoving) {
        BlockState neighborState = level.getBlockState(neighborPos);
        if (neighborState.is(Blocks.WATER) || neighborState.is(Blocks.LAVA)) {
            level.setBlock(pos, ((Block)BlockRegistry.SOLID_CORRUPTION.get()).defaultBlockState(), 3);
        }
        super.neighborChanged(state, level, pos, block, neighborPos, isMoving);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.animateTick(state, level, pos, random);
        Vec3 spawnPos = new Vec3((double)pos.getX(), (double)pos.getY() + 1.0, (double)pos.getZ());
        if (random.nextInt(30) == 0) {
            level.addParticle((ParticleOptions)ParticleRegistry.BLACK_CORRUPTION.get(), spawnPos.x + random.nextDouble(), spawnPos.y, spawnPos.z + random.nextDouble(), 0.0, (random.nextDouble() + 0.5) * 0.1, 0.0);
        }
    }
}

