/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wardentools.blockentity.BlockEntityRegistry;
import wardentools.blockentity.ProtectorInvokerBlockEntity;

public class ProtectorInvokerBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE_FOOT = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final VoxelShape SHAPE_BASE = Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);
    private static final VoxelShape SHAPE_STICK = Block.box((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
    private static final VoxelShape SHAPE_SUPPORT = Block.box((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape SHAPE_GLASS = Block.box((double)4.5, (double)10.0, (double)4.5, (double)11.5, (double)16.0, (double)11.5);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)SHAPE_FOOT, (VoxelShape[])new VoxelShape[]{SHAPE_BASE, SHAPE_STICK, SHAPE_SUPPORT, SHAPE_GLASS});

    public ProtectorInvokerBlock(BlockBehaviour.Properties prop) {
        super(prop);
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.PROTECTOR_INVOKER_BLOCK_ENTITY.get()).create(pos, state);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return level.isClientSide() ? null : (level0, pos0, state0, blockEntity) -> ((ProtectorInvokerBlockEntity)blockEntity).tick();
    }

    protected boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        return switch (this.use(level, pos, player, hand)) {
            case InteractionResult.SUCCESS -> ItemInteractionResult.SUCCESS;
            case InteractionResult.FAIL -> ItemInteractionResult.FAIL;
            default -> ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        };
    }

    @NotNull
    public InteractionResult use(Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ProtectorInvokerBlockEntity)) {
            return InteractionResult.PASS;
        }
        ProtectorInvokerBlockEntity invoker = (ProtectorInvokerBlockEntity)blockEntity;
        if (InteractionHand.MAIN_HAND != interactionHand) {
            return InteractionResult.FAIL;
        }
        return invoker.playerInteract(player, pos, interactionHand);
    }

    public void onRemove(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockEntity be;
        if (!level.isClientSide() && (be = level.getBlockEntity(pos)) instanceof ProtectorInvokerBlockEntity) {
            ProtectorInvokerBlockEntity blockEntity = (ProtectorInvokerBlockEntity)be;
            ItemStackHandler inventory = blockEntity.getInventory();
            for (int index = 0; index < inventory.getSlots(); ++index) {
                ItemStack stackDrop = inventory.getStackInSlot(index).copy();
                ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stackDrop);
                level.addFreshEntity((Entity)entity);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }
}

