/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import wardentools.block.CrystalBlock;
import wardentools.misc.Crystal;
import wardentools.particle.ParticleRegistry;

public class RadianceCrystalBlock
extends CrystalBlock {
    private static final double SPEED = 0.1;
    private static final int PERIOD = 40;

    public RadianceCrystalBlock(float height, float length, BlockBehaviour.Properties properties) {
        super(height, length, 8, Crystal.PALE, properties);
    }

    @Override
    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.animateTick(state, level, pos, random);
        Vec3 spawnPos = pos.getCenter();
        if (random.nextInt(40) == 0) {
            level.addParticle((ParticleOptions)ParticleRegistry.RADIANCE.get(), spawnPos.x, spawnPos.y, spawnPos.z, (random.nextDouble() - 0.5) * 0.1, (random.nextDouble() - 0.5) * 0.1, (random.nextDouble() - 0.5) * 0.1);
        }
    }
}

