/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;
import wardentools.block.LiquidCorruptionBlock;
import wardentools.effect.ModEffects;

public class SolidCorruptionBlock
extends Block {
    public SolidCorruptionBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(@NotNull BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos blockPos, @NotNull RandomSource random) {
        if (this.noLiquidNeighbor((Level)level, blockPos)) {
            level.setBlockAndUpdate(blockPos, ((LiquidCorruptionBlock)((Object)BlockRegistry.LIQUID_CORRUPTION_BLOCK.get())).defaultBlockState());
        }
    }

    public void stepOn(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull Entity entity) {
        super.stepOn(level, blockPos, blockState, entity);
        if (entity instanceof LivingEntity) {
            LivingEntity entity1 = (LivingEntity)entity;
            if (entity instanceof LivingEntity && ModEffects.PURIFIED.getHolder().isPresent() && ((LivingEntity)entity).hasEffect((Holder)ModEffects.PURIFIED.getHolder().get())) {
                return;
            }
            if (ModEffects.CORRUPTED.getHolder().isEmpty()) {
                return;
            }
            entity1.addEffect(new MobEffectInstance((Holder)ModEffects.CORRUPTED.getHolder().get(), 40, 0, false, false));
        }
    }

    private boolean noLiquidNeighbor(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = level.getBlockState(neighborPos);
            if (!neighborState.is(Blocks.WATER) && !neighborState.is(Blocks.LAVA)) continue;
            return false;
        }
        return true;
    }
}

