/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;
import wardentools.blockentity.BlockEntityRegistry;
import wardentools.blockentity.SoulSpawnerBlockEntity;
import wardentools.entity.ModEntities;
import wardentools.entity.custom.ShadowEntity;

public class SoulSpawner
extends Block
implements EntityBlock {
    private static final int SPAWN_REDUCER = 2;
    private static final int MAX_SHADOWS = 6;
    private static final float MAX_SHADOW_CHECK_DISTANCE = 10.0f;

    public SoulSpawner(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(@NotNull BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos blockPos, @NotNull RandomSource random) {
        if (level.isClientSide()) {
            return;
        }
        if (random.nextInt(2) == 0) {
            if (this.checkForManyShadowsAround((Level)level, blockPos)) {
                return;
            }
            BlockPos spawnPos = this.findSpawnPos((Level)level, blockPos);
            if (spawnPos == null) {
                return;
            }
            ShadowEntity shadow = new ShadowEntity((EntityType<? extends Monster>)((EntityType)ModEntities.SHADOW.get()), (Level)level);
            shadow.setStasis(true);
            float rot = random.nextFloat() * 360.0f;
            shadow.setYRot(rot);
            shadow.setYBodyRot(rot);
            shadow.setYHeadRot(rot);
            shadow.moveTo((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5, 0.0f, 0.0f);
            level.addFreshEntityWithPassengers((Entity)shadow);
        }
    }

    private boolean checkForManyShadowsAround(@NotNull Level level, @NotNull BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof SoulSpawnerBlockEntity) {
            ShadowEntity shadowEntity;
            SoulSpawnerBlockEntity soulSpawner = (SoulSpawnerBlockEntity)be;
            if (soulSpawner.getShadowEntity() == null && (shadowEntity = (ShadowEntity)((EntityType)ModEntities.SHADOW.get()).create(level)) != null) {
                shadowEntity.moveTo(soulSpawner.getBlockPos(), 0.0f, 0.0f);
                soulSpawner.setShadowEntity(shadowEntity);
            }
            return level.getEntities((Entity)soulSpawner.getShadowEntity(), this.getShape(this.defaultBlockState(), (BlockGetter)level, pos, CollisionContext.empty()).bounds().move(pos).inflate(10.0)).size() > 6;
        }
        return false;
    }

    @Nullable
    private BlockPos findSpawnPos(@NotNull Level level, @NotNull BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int size = 6;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int dx = -size; dx <= size; ++dx) {
            for (int dy = -size / 2; dy <= size / 2; ++dy) {
                for (int dz = -size; dz <= size; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    BlockPos newPos = new BlockPos(x + dx, y + dy, z + dz);
                    positions.add(newPos);
                }
            }
        }
        Collections.shuffle(positions);
        for (BlockPos newPos : positions) {
            if (!level.getBlockState(newPos).isAir() || !level.getBlockState(newPos.below()).isCollisionShapeFullBlock((BlockGetter)level, newPos.below()) || !level.getBlockState(newPos.above()).isAir()) continue;
            return newPos;
        }
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.SOUL_SPAWNER_BLOCK_ENTITY.get()).create(pos, state);
    }

    public int getExpDrop(BlockState state, LevelReader world, RandomSource randomSource, BlockPos pos, int fortune, int silktouch) {
        return 15 + randomSource.nextInt(15) + randomSource.nextInt(15);
    }

    public boolean isRandomlyTicking(@NotNull BlockState state) {
        return true;
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource source) {
        for (int i = 0; i < level.random.nextInt(4) + 1; ++i) {
            double offsetX = source.nextDouble();
            double offsetY = source.nextDouble();
            double offsetZ = source.nextDouble();
            level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)pos.getX() + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + offsetZ, 0.0, 0.0, 0.0);
        }
    }
}

